/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit.jee.statement;

import jakarta.ejb.embeddable.EJBContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.junit.jee.config.Property;
import org.apache.openejb.junit.jee.config.PropertyFile;
import org.apache.openejb.junit.jee.statement.DecoratingStatement;
import org.apache.openejb.osgi.client.LocalInitialContextFactory;
import org.apache.openejb.util.Classes;
import org.junit.runners.model.Statement;

public class StartingStatement
extends DecoratingStatement {
    private final Class<?> clazz;
    private Properties properties;
    private EJBContainer container;

    public StartingStatement(Statement statement, Class<?> clazz) {
        super(statement);
        this.clazz = clazz;
    }

    @Override
    protected void before() throws Exception {
        org.apache.openejb.junit.jee.config.Properties annotationConfig;
        String path;
        PropertyFile propertyFile;
        this.properties = new Properties();
        StringBuilder b = new StringBuilder();
        for (Class c : Classes.ancestors(this.clazz)) {
            if (c == Object.class) continue;
            b.append(c.getName()).append(",");
        }
        b.setLength(b.length() - 1);
        this.properties.put("openejb.additionnal.callers", b.toString());
        InputStream is = this.clazz.getClassLoader().getResourceAsStream("openejb-junit.properties");
        if (is != null) {
            this.properties.load(is);
        }
        if ((propertyFile = this.clazz.getAnnotation(PropertyFile.class)) != null && !(path = propertyFile.value()).isEmpty()) {
            InputStream is2 = this.clazz.getClassLoader().getResourceAsStream(path);
            if (is2 == null) {
                File file = new File(path);
                if (file.exists()) {
                    is2 = new FileInputStream(file);
                } else {
                    throw new OpenEJBException("properties resource '" + path + "' not found");
                }
            }
            this.properties.load(is2);
        }
        if ((annotationConfig = this.clazz.getAnnotation(org.apache.openejb.junit.jee.config.Properties.class)) != null) {
            for (Property property : annotationConfig.value()) {
                this.properties.put(property.key(), property.value());
            }
        }
        if (!this.properties.containsKey("java.naming.factory.initial")) {
            this.properties.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        }
        this.container = EJBContainer.createEJBContainer((Map)this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public EJBContainer getContainer() {
        return this.container;
    }
}

