/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.ApplicationException;
import org.apache.openejb.jee.AttributeBinding;
import org.apache.openejb.jee.ContainerConcurrency;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodAttribute;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.SecurityRole;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="assembly-descriptorType", propOrder={"securityRole", "methodPermission", "containerTransaction", "containerConcurrency", "interceptorBinding", "messageDestination", "excludeList", "applicationException"})
public class AssemblyDescriptor {
    @XmlElement(name="security-role", required=true)
    protected List<SecurityRole> securityRole;
    @XmlElement(name="method-permission", required=true)
    protected List<MethodPermission> methodPermission;
    @XmlElement(name="container-transaction", required=true)
    protected List<ContainerTransaction> containerTransaction;
    @XmlElement(name="container-concurrency", required=true)
    protected List<ContainerConcurrency> containerConcurrency;
    @XmlElement(name="interceptor-binding", required=true)
    protected List<InterceptorBinding> interceptorBinding;
    @XmlElement(name="message-destination", required=true)
    protected List<MessageDestination> messageDestination;
    @XmlElement(name="exclude-list")
    protected ExcludeList excludeList;
    @XmlElement(name="application-exception", required=true)
    protected KeyedCollection<String, ApplicationException> applicationException;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public List<SecurityRole> getSecurityRole() {
        if (this.securityRole == null) {
            this.securityRole = new ArrayList<SecurityRole>();
        }
        return this.securityRole;
    }

    public List<MethodPermission> getMethodPermission() {
        if (this.methodPermission == null) {
            this.methodPermission = new ArrayList<MethodPermission>();
        }
        return this.methodPermission;
    }

    public List<ContainerTransaction> getContainerTransaction() {
        if (this.containerTransaction == null) {
            this.containerTransaction = new ArrayList<ContainerTransaction>();
        }
        return this.containerTransaction;
    }

    public Map<String, List<MethodAttribute>> getMethodTransactionMap(String ejbName) {
        return this.getMethodAttributes(ejbName, this.getContainerTransaction());
    }

    public List<ContainerConcurrency> getContainerConcurrency() {
        if (this.containerConcurrency == null) {
            this.containerConcurrency = new ArrayList<ContainerConcurrency>();
        }
        return this.containerConcurrency;
    }

    public Map<String, List<MethodAttribute>> getMethodConcurrencyMap(String ejbName) {
        return this.getMethodAttributes(ejbName, this.getContainerConcurrency());
    }

    private Map<String, List<MethodAttribute>> getMethodAttributes(String ejbName, List<? extends AttributeBinding> bindings) {
        LinkedHashMap<String, List<MethodAttribute>> methods = new LinkedHashMap<String, List<MethodAttribute>>();
        for (AttributeBinding attributeBinding : bindings) {
            for (Method method : attributeBinding.getMethod()) {
                if (!method.getEjbName().equals(ejbName)) continue;
                String methodName = method.getMethodName();
                List list = methods.computeIfAbsent(methodName, k -> new ArrayList());
                list.add(new MethodAttribute(attributeBinding.getAttribute(), method));
            }
        }
        return methods;
    }

    public List<InterceptorBinding> getInterceptorBinding() {
        if (this.interceptorBinding == null) {
            this.interceptorBinding = new ArrayList<InterceptorBinding>();
        }
        return this.interceptorBinding;
    }

    public InterceptorBinding addInterceptorBinding(InterceptorBinding binding) {
        this.getInterceptorBinding().add(binding);
        return binding;
    }

    public List<MessageDestination> getMessageDestination() {
        if (this.messageDestination == null) {
            this.messageDestination = new ArrayList<MessageDestination>();
        }
        return this.messageDestination;
    }

    public ExcludeList getExcludeList() {
        if (this.excludeList == null) {
            this.excludeList = new ExcludeList();
        }
        return this.excludeList;
    }

    public void setExcludeList(ExcludeList value) {
        this.excludeList = value;
    }

    public Collection<ApplicationException> getApplicationException() {
        if (this.applicationException == null) {
            this.applicationException = new KeyedCollection();
        }
        return this.applicationException;
    }

    public Map<String, ApplicationException> getApplicationExceptionMap() {
        return ((KeyedCollection)this.getApplicationException()).toMap();
    }

    public ApplicationException getApplicationException(String className) {
        return this.getApplicationExceptionMap().get(className);
    }

    public ApplicationException getApplicationException(Class clazz) {
        return this.getApplicationException(clazz.getName());
    }

    public void addApplicationException(Class clazz, boolean rollback, boolean inherited) {
        this.getApplicationException().add(new ApplicationException(clazz, rollback));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }
}

