/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jpa;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;


/**
 * @Target({TYPE}) @Retention(RUNTIME)
 * public @interface DiscriminatorColumn {
 * String name() default "DTYPE";
 * DiscriminatorType discriminatorType() default STRING;
 * String columnDefinition() default "";
 * int length() default 31;
 * }
 * <p/>
 * <p/>
 * <p/>
 * <p>Java class for discriminator-column complex type.
 * <p/>
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p/>
 * <pre>
 * &lt;complexType name="discriminator-column">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="column-definition" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="discriminator-type" type="{http://java.sun.com/xml/ns/persistence/orm}discriminator-type" />
 *       &lt;attribute name="length" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       &lt;attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "discriminator-column")
public class DiscriminatorColumn {

    @XmlAttribute(name = "column-definition")
    protected String columnDefinition;
    @XmlAttribute(name = "discriminator-type")
    protected DiscriminatorType discriminatorType;
    @XmlAttribute
    protected Integer length;
    @XmlAttribute
    protected String name;

    /**
     * Gets the value of the columnDefinition property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getColumnDefinition() {
        return columnDefinition;
    }

    /**
     * Sets the value of the columnDefinition property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setColumnDefinition(final String value) {
        this.columnDefinition = value;
    }

    /**
     * Gets the value of the discriminatorType property.
     *
     * @return possible object is
     * {@link DiscriminatorType }
     */
    public DiscriminatorType getDiscriminatorType() {
        return discriminatorType;
    }

    /**
     * Sets the value of the discriminatorType property.
     *
     * @param value allowed object is
     *              {@link DiscriminatorType }
     */
    public void setDiscriminatorType(final DiscriminatorType value) {
        this.discriminatorType = value;
    }

    /**
     * Gets the value of the length property.
     *
     * @return possible object is
     * {@link Integer }
     */
    public Integer getLength() {
        return length;
    }

    /**
     * Sets the value of the length property.
     *
     * @param value allowed object is
     *              {@link Integer }
     */
    public void setLength(final Integer value) {
        this.length = value;
    }

    /**
     * Gets the value of the name property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setName(final String value) {
        this.name = value;
    }

}
