/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import java.security.Principal;
import org.apache.openejb.test.servlet.SecureEJBLocal;

@Stateless
@DeclareRoles(value={"user", "manager", "UNKNOWN", "runas"})
public class SecureEJB
implements SecureEJBLocal {
    @Resource
    private SessionContext context;

    @Override
    public Principal getCallerPrincipal() {
        return this.context.getCallerPrincipal();
    }

    @Override
    public boolean isCallerInRole(String role) {
        return this.context.isCallerInRole(role);
    }

    @Override
    @RolesAllowed(value={"user"})
    public void allowUserMethod() {
    }

    @Override
    @RolesAllowed(value={"manager"})
    public void allowManagerMethod() {
    }

    @Override
    @RolesAllowed(value={"UNKNOWN"})
    public void allowUnknownMethod() {
    }

    @Override
    @RolesAllowed(value={"runas"})
    public void allowRunasMethod() {
    }

    @Override
    @DenyAll
    public void denyAllMethod() {
    }

    public String toString() {
        return "SecureEJB[userName=" + this.getCallerPrincipal() + "]";
    }
}

