/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.servlet.JndiTestServlet;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.junit.Assert;

public class AnnotatedServlet
extends HttpServlet
implements JndiTestServlet {
    @EJB(beanName="BasicBmpBean")
    private BasicBmpHome bmpHome;
    @EJB(beanName="BasicStatefulBean")
    private BasicStatefulHome statefulHome;
    @EJB(beanName="BasicStatelessBean")
    private BasicStatelessHome statelessHome;
    @Resource
    private String striing;
    @Resource
    private Double doouble;
    @Resource
    private Long loong;
    @Resource
    private Float flooat;
    @Resource
    private Integer inteeger;
    @Resource
    private Short shoort;
    @Resource
    private Boolean booolean;
    @Resource
    private Byte byyte;
    @Resource
    private Character chaaracter;
    @Resource
    private DataSource daataSource;
    @Resource
    private ConnectionFactory coonnectionFactory;
    @Resource
    private QueueConnectionFactory queueCoonnectionFactory;
    @Resource
    private TopicConnectionFactory topicCoonnectionFactory;
    @PersistenceUnit(unitName="openjpa-test-unit")
    private EntityManagerFactory emf;
    @PersistenceContext(unitName="openjpa-test-unit")
    private EntityManager em;
    @EJB
    private BasicStatelessBusinessLocal statelessBusinessLocal;
    @EJB
    private BasicStatelessBusinessRemote statelessBusinessRemote;
    @EJB
    private BasicStatefulBusinessLocal statefulBusinessLocal;
    @EJB
    private BasicStatefulBusinessRemote statefulBusinessRemote;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out);
        String methodName = request.getParameter("method");
        if (methodName == null) {
            this.testAll(printStream);
        } else {
            try {
                Method method = this.getClass().getMethod(methodName, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                printStream.println("FAILED");
                e.printStackTrace(printStream);
            }
        }
        printStream.flush();
    }

    public void testAll(PrintStream printStream) {
        for (Method method : JndiTestServlet.class.getMethods()) {
            try {
                method.invoke((Object)this, new Object[0]);
                printStream.println(method.getName() + " PASSED");
            }
            catch (Throwable e) {
                printStream.println(method.getName() + " FAILED");
                e.printStackTrace(printStream);
                printStream.flush();
            }
            printStream.println();
        }
    }

    @Override
    public void lookupEntityBean() {
        Assert.assertNotNull((String)"The EJBObject is null", (Object)this.bmpHome);
    }

    @Override
    public void lookupStatefulBean() {
        Assert.assertNotNull((String)"The EJBObject is null", (Object)this.statefulHome);
    }

    @Override
    public void lookupStatelessBean() {
        Assert.assertNotNull((String)"The EJBObject is null", (Object)this.statelessHome);
    }

    @Override
    public void lookupStatelessBusinessLocal() {
        Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)this.statelessBusinessLocal);
    }

    @Override
    public void lookupStatelessBusinessRemote() {
        Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)this.statelessBusinessRemote);
    }

    @Override
    public void lookupStatefulBusinessLocal() {
        Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)this.statefulBusinessLocal);
    }

    @Override
    public void lookupStatefulBusinessRemote() {
        Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)this.statefulBusinessRemote);
    }

    @Override
    public void lookupStringEntry() {
        String expected = "1";
        Assert.assertNotNull((String)"The String looked up is null", (Object)this.striing);
        Assert.assertEquals((Object)"1", (Object)this.striing);
    }

    @Override
    public void lookupDoubleEntry() {
        Double expected = 1.0;
        Assert.assertNotNull((String)"The Double looked up is null", (Object)this.doouble);
        Assert.assertEquals((Object)expected, (Object)this.doouble);
    }

    @Override
    public void lookupLongEntry() {
        Long expected = 1L;
        Assert.assertNotNull((String)"The Long looked up is null", (Object)this.loong);
        Assert.assertEquals((Object)expected, (Object)this.loong);
    }

    @Override
    public void lookupFloatEntry() {
        Float expected = Float.valueOf(1.0f);
        Assert.assertNotNull((String)"The Float looked up is null", (Object)this.flooat);
        Assert.assertEquals((Object)expected, (Object)this.flooat);
    }

    @Override
    public void lookupIntegerEntry() {
        Integer expected = 1;
        Assert.assertNotNull((String)"The Integer looked up is null", (Object)this.inteeger);
        Assert.assertEquals((Object)expected, (Object)this.inteeger);
    }

    @Override
    public void lookupShortEntry() {
        Short expected = 1;
        Assert.assertNotNull((String)"The Short looked up is null", (Object)this.shoort);
        Assert.assertEquals((Object)expected, (Object)this.shoort);
    }

    @Override
    public void lookupBooleanEntry() {
        Boolean expected = true;
        Assert.assertNotNull((String)"The Boolean looked up is null", (Object)this.booolean);
        Assert.assertEquals((Object)expected, (Object)this.booolean);
    }

    @Override
    public void lookupByteEntry() {
        Byte expected = 1;
        Assert.assertNotNull((String)"The Byte looked up is null", (Object)this.byyte);
        Assert.assertEquals((Object)expected, (Object)this.byyte);
    }

    @Override
    public void lookupCharacterEntry() {
        Character expected = Character.valueOf('D');
        Assert.assertNotNull((String)"The Character looked up is null", (Object)this.chaaracter);
        Assert.assertEquals((Object)expected, (Object)this.chaaracter);
    }

    @Override
    public void lookupResource() {
        Assert.assertNotNull((String)"The DataSource is null", (Object)this.daataSource);
    }

    @Override
    public void lookupJMSConnectionFactory() {
        try {
            this.testJmsConnection(this.coonnectionFactory.createConnection());
            this.testJmsConnection(this.queueCoonnectionFactory.createConnection());
            this.testJmsConnection(this.topicCoonnectionFactory.createConnection());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    private void testJmsConnection(Connection connection) throws JMSException {
        Session session = connection.createSession(false, 3);
        Topic topic = session.createTopic("test");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send(session.createMessage());
        producer.close();
        session.close();
        connection.close();
    }

    @Override
    public void lookupPersistenceUnit() {
        Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)this.emf);
    }

    @Override
    public void lookupPersistenceContext() {
        Assert.assertNotNull((String)"The EntityManager is null", (Object)this.em);
        try {
            this.em.getFlushMode();
        }
        catch (Exception e) {
            Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

