/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

public class JndiServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        TreeMap<String, Object> bindings = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/");
            this.addBindings("", bindings, context);
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
        out.println("JNDI Context:");
        for (Map.Entry entry : bindings.entrySet()) {
            if (entry.getValue() != null) {
                out.println("  " + (String)entry.getKey() + "=" + String.valueOf(entry.getValue()));
                continue;
            }
            out.println("  " + (String)entry.getKey());
        }
    }

    private void addBindings(String path, Map<String, Object> bindings, Context context) {
        try {
            for (NameClassPair pair : Collections.list(context.list(""))) {
                String name = pair.getName();
                String className = pair.getClassName();
                if ("org.apache.naming.resources.FileDirContext$FileResource".equals(className)) {
                    bindings.put(path + name, "<file>");
                    continue;
                }
                try {
                    Object value = context.lookup(name);
                    if (value instanceof Context) {
                        Context nextedContext = (Context)value;
                        bindings.put(path + name, "");
                        this.addBindings(path + name + "/", bindings, nextedContext);
                        continue;
                    }
                    bindings.put(path + name, value);
                }
                catch (NamingException e) {
                    bindings.put(path + name, "ERROR: " + e.getMessage());
                }
            }
        }
        catch (NamingException e) {
            bindings.put(path, "ERROR: list bindings threw an exception: " + e.getMessage());
        }
    }
}

