/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import jakarta.ejb.TransactionRolledbackLocalException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.cmrmapping.ManyOwningSideLocal;
import org.apache.openejb.test.entity.cmr.cmrmapping.ManyOwningSideLocalHome;
import org.apache.openejb.test.entity.cmr.cmrmapping.OneInverseSideLocal;
import org.apache.openejb.test.entity.cmr.cmrmapping.OneInverseSideLocalHome;
import org.apache.openejb.test.entity.cmr.cmrmapping.OneOwningSideLocal;
import org.apache.openejb.test.entity.cmr.cmrmapping.OneOwningSideLocalHome;
import org.junit.Assert;

public class CmrMappingTests
extends AbstractCMRTest {
    private Integer compoundPK_20_10;
    private Integer compoundPK_20_10_field1;
    private Integer compoundPK_20_20;
    private Integer compoundPK_20_20_field1;
    private Set<Integer> oneOwningCreated = new HashSet<Integer>();
    private Set<Integer> oneInverseCreated = new HashSet<Integer>();
    private Set<Integer> manyCreated = new HashSet<Integer>();
    private OneInverseSideLocalHome oneInverseHome;
    private OneOwningSideLocalHome oneOwningHome;
    private ManyOwningSideLocalHome manyHome;

    public CmrMappingTests() {
        super("CmrMappingTests.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.compoundPK_20_10 = new Integer(20);
        this.compoundPK_20_10_field1 = new Integer(10);
        this.compoundPK_20_20 = new Integer(20);
        this.compoundPK_20_20_field1 = new Integer(20);
        this.oneInverseHome = (OneInverseSideLocalHome)this.initialContext.lookup("java:openejb/local/client/tests/entity/cmp2/OneInverseSideBean/EJBHomeLocal");
        this.oneOwningHome = (OneOwningSideLocalHome)this.initialContext.lookup("java:openejb/local/client/tests/entity/cmp2/OneOwningSideBean/EJBHomeLocal");
        this.manyHome = (ManyOwningSideLocalHome)this.initialContext.lookup("java:openejb/local/client/tests/entity/cmp2/ManyOwningSideBean/EJBHomeLocal");
    }

    public void testOneToOneSetCMROnOwningSide() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            owningLocal.setOneInverseSide(inverseLocal);
            this.completeTransaction();
            this.validateOneToOneRelationship();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDb() {
        for (Integer id : this.oneOwningCreated) {
            try {
                this.findOneOwningSide(id).remove();
            }
            catch (Exception exception) {}
            continue;
            finally {
                try {
                    this.completeTransaction();
                }
                catch (Exception exception) {}
            }
        }
        this.oneOwningCreated.clear();
        for (Integer id : this.oneInverseCreated) {
            try {
                this.findOneInverseSide(id).remove();
            }
            catch (Exception exception) {}
            continue;
            finally {
                try {
                    this.completeTransaction();
                }
                catch (Exception exception) {}
            }
        }
        this.oneInverseCreated.clear();
        for (Integer id : this.manyCreated) {
            try {
                this.findManyOwningSide(id).remove();
            }
            catch (Exception exception) {}
            continue;
            finally {
                try {
                    this.completeTransaction();
                }
                catch (Exception exception) {}
            }
        }
        this.manyCreated.clear();
    }

    public void testOneToOneSetCMROnOwningSideResetPK() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_20, this.compoundPK_20_20_field1);
            owningLocal.setOneInverseSide(inverseLocal);
            this.completeTransaction();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                e.printStackTrace();
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToOneSetCMROnInverseSide() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            inverseLocal.setOneOwningSide(owningLocal);
            this.completeTransaction();
            this.validateOneToOneRelationship();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToOneSetCMROnInverseSideResetPK() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            OneOwningSideLocal owningLocal = this.createOneOwningSide(this.compoundPK_20_20, this.compoundPK_20_20_field1);
            inverseLocal.setOneOwningSide(owningLocal);
            this.completeTransaction();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                e.printStackTrace();
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToOneDoNotSetCMR() throws Exception {
        this.beginTransaction();
        try {
            this.createOneOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            this.completeTransaction();
            this.completeTransaction();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToManySetCMROnOwningSide() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            owningLocal.setOneInverseSide(inverseLocal);
            this.completeTransaction();
            this.validateOneToManyRelationship();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testEjbSelectWithCMR() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            owningLocal.setOneInverseSide(inverseLocal);
            this.completeTransaction();
            owningLocal.testEJBSelect();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToManySetCMROnOwningSideResetPK() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_20, this.compoundPK_20_20_field1);
            owningLocal.setOneInverseSide(inverseLocal);
            this.completeTransaction();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                e.printStackTrace();
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToManySetCMROnInverseSide() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            inverseLocal.setManyOwningSide(Collections.singleton(owningLocal));
            this.completeTransaction();
            this.validateOneToManyRelationship();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToManySetCMROnInverseSideResetPK() throws Exception {
        this.beginTransaction();
        try {
            OneInverseSideLocal inverseLocal = this.createOneInverseSide(this.compoundPK_20_10_field1);
            ManyOwningSideLocal owningLocal = this.createManyOwningSide(this.compoundPK_20_20, this.compoundPK_20_20_field1);
            inverseLocal.setManyOwningSide(Collections.singleton(owningLocal));
            this.completeTransaction();
        }
        catch (TransactionRolledbackLocalException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                e.printStackTrace();
                throw new TestFailureException(new AssertionFailedError("Received Exception " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    public void testOneToManyDoNotSetCMR() throws Exception {
        this.beginTransaction();
        try {
            this.createManyOwningSide(this.compoundPK_20_10, this.compoundPK_20_10_field1);
            this.completeTransaction();
            this.completeTransaction();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TestFailureException(new AssertionFailedError("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.completeTransaction();
            this.cleanDb();
        }
    }

    private OneInverseSideLocal createOneInverseSide(Integer id) throws Exception {
        OneInverseSideLocalHome home = this.oneInverseHome;
        OneInverseSideLocal oneInverseSideLocal = home.create(id);
        this.oneInverseCreated.add(id);
        return oneInverseSideLocal;
    }

    private OneInverseSideLocal findOneInverseSide(Integer id) throws Exception {
        OneInverseSideLocalHome home = this.oneInverseHome;
        return home.findByPrimaryKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOneToOneRelationship() throws Exception {
        try {
            OneInverseSideLocal inverseLocal = this.findOneInverseSide(this.compoundPK_20_10_field1);
            OneOwningSideLocal oneOwningSide = inverseLocal.getOneOwningSide();
            Assert.assertNotNull((Object)oneOwningSide);
            Assert.assertEquals((Object)this.compoundPK_20_10, (Object)oneOwningSide.getPrimaryKey());
            OneInverseSideLocal inverseBackRef = oneOwningSide.getOneInverseSide();
            Assert.assertNotNull((Object)inverseBackRef);
            Assert.assertEquals((Object)this.compoundPK_20_10_field1, (Object)inverseBackRef.getPrimaryKey());
            this.completeTransaction();
        }
        finally {
            this.completeTransaction();
        }
    }

    private OneOwningSideLocal createOneOwningSide(Integer id, Integer field1) throws Exception {
        OneOwningSideLocalHome home = this.oneOwningHome;
        OneOwningSideLocal oneOwningSideLocal = home.create(id, field1);
        this.oneOwningCreated.add(id);
        return oneOwningSideLocal;
    }

    private OneOwningSideLocal findOneOwningSide(Integer id) throws Exception {
        OneOwningSideLocalHome home = this.oneOwningHome;
        return home.findByPrimaryKey(id);
    }

    private ManyOwningSideLocal createManyOwningSide(Integer id, Integer field1) throws Exception {
        ManyOwningSideLocalHome home = this.manyHome;
        ManyOwningSideLocal manyOwningSideLocal = home.create(id, field1);
        this.manyCreated.add(id);
        return manyOwningSideLocal;
    }

    private ManyOwningSideLocal findManyOwningSide(Integer id) throws Exception {
        ManyOwningSideLocalHome home = this.manyHome;
        return home.findByPrimaryKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOneToManyRelationship() throws NotSupportedException, SystemException, Exception, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        try {
            OneInverseSideLocal inverseLocal = this.findOneInverseSide(this.compoundPK_20_10_field1);
            Set set = inverseLocal.getManyOwningSide();
            Assert.assertEquals((long)1L, (long)set.size());
            ManyOwningSideLocal owningLocal = (ManyOwningSideLocal)set.iterator().next();
            Assert.assertEquals((Object)this.compoundPK_20_10, (Object)owningLocal.getPrimaryKey());
            OneInverseSideLocal oneInverseSide = owningLocal.getOneInverseSide();
            Assert.assertNotNull((Object)oneInverseSide);
            Assert.assertEquals((Object)this.compoundPK_20_10_field1, (Object)oneInverseSide.getPrimaryKey());
            this.completeTransaction();
        }
        finally {
            this.completeTransaction();
        }
    }
}

