/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.ObjectNotFoundException;
import org.apache.openejb.test.entity.cmp.BasicCmpHome;
import org.apache.openejb.test.entity.cmp2.BasicCmp2TestClient;

public class Cmp2EjbObjectTests
extends BasicCmp2TestClient {
    public Cmp2EjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/BasicCmpHome");
        this.ejbHome = (BasicCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Third Bean");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            Cmp2EjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            Cmp2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getPrimaryKey() {
        try {
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            Cmp2EjbObjectTests.assertNotNull((String)"The primary key is null", (Object)this.ejbPrimaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            Cmp2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        try {
            Cmp2EjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Cmp2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            Cmp2EjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            Cmp2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbHome.findByPrimaryKey((Integer)this.ejbPrimaryKey);
                Cmp2EjbObjectTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                Cmp2EjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            Cmp2EjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

