/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.test.TestServer;

public class RemoteTestServer
implements TestServer {
    private boolean serverRunning = false;
    private Process serverProcess = null;
    private Properties properties;

    @Override
    public void init(Properties props) {
        this.properties = props;
        if (props.contains("java.naming.security.principal")) {
            throw new IllegalArgumentException("Not allowed 'java.naming.security.principal'");
        }
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", "127.0.0.1:4201");
    }

    @Override
    public synchronized void start() {
        if (!this.connect()) {
            try {
                System.out.println("[] START SERVER");
                String openejbHome = System.getProperty("openejb.home");
                File home = new File(openejbHome);
                System.out.println("OPENEJB_HOME = " + home.getAbsolutePath());
                String systemInfo = "Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "/" + System.getProperty("os.version");
                System.out.println("SYSTEM_INFO  = " + systemInfo);
                File openejbJar = null;
                File lib = new File(home, "lib");
                File[] files = lib.listFiles();
                if (null != files) {
                    for (int i = 0; i < files.length && openejbJar == null; ++i) {
                        File file = files[i];
                        if (!file.getName().startsWith("openejb-core") || !file.getName().endsWith("jar")) continue;
                        openejbJar = file;
                    }
                }
                if (openejbJar == null) {
                    throw new IllegalStateException("Cannot find the openejb-core jar in " + lib.getAbsolutePath());
                }
                boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
                String[] args = new String[]{isWindows ? "java.exe" : "java", "-jar", openejbJar.getAbsolutePath(), "start"};
                this.serverProcess = Runtime.getRuntime().exec(args);
                InputStream out = this.serverProcess.getInputStream();
                Thread serverOut = new Thread(new Pipe(out, System.out));
                serverOut.setDaemon(true);
                serverOut.start();
                InputStream err = this.serverProcess.getErrorStream();
                Thread serverErr = new Thread(new Pipe(err, System.err));
                serverErr.setDaemon(true);
                serverErr.start();
                this.connect(10);
                this.serverRunning = true;
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException("Cannot start the server.").initCause(e);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.serverRunning) {
            try {
                System.out.println("[] STOP SERVER");
                Socket socket = new Socket("localhost", 4200);
                OutputStream out = socket.getOutputStream();
                out.write("Stop".getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != this.serverProcess) {
            try {
                this.serverProcess.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Properties getContextEnvironment() {
        return (Properties)this.properties.clone();
    }

    private boolean connect() {
        return this.connect(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(int tries) {
        OutputStream out = null;
        try {
            Socket socket = new Socket("localhost", 4200);
            out = socket.getOutputStream();
        }
        catch (Exception e) {
            if (tries < 2) {
                boolean bl = false;
                return bl;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            boolean bl = this.connect(--tries);
            return bl;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return true;
    }

    static {
        System.setProperty("noBanner", "true");
    }

    private static final class Pipe
    implements Runnable {
        private final InputStream is;
        private final OutputStream out;

        private Pipe(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int i = this.is.read();
                this.out.write(i);
                while (i != -1) {
                    i = this.is.read();
                    this.out.write(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

