/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessRemoteIntfcTests
extends BasicStatelessTestClient {
    public StatelessRemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessRemoteIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessRemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessRemoteIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            StatelessRemoteIntfcTests.assertNotNull((String)"Nested exception should not be null", (Object)n);
            StatelessRemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessRemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            StatelessRemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Throwable e) {
            StatelessRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

