/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.StatefulTestClient;

public class StatefulLocalBusinessIntfcTests
extends StatefulTestClient {
    private BasicStatefulBusinessLocal businessLocal;

    public StatefulLocalBusinessIntfcTests() {
        super("LocalBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulPojoHomeBusinessLocal");
        StatefulLocalBusinessIntfcTests.assertNotNull((Object)obj);
        StatefulLocalBusinessIntfcTests.assertTrue((String)"instance of BasicStatefulBusinessLocal", (boolean)(obj instanceof BasicStatefulBusinessLocal));
        this.businessLocal = (BasicStatefulBusinessLocal)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessLocal.businessMethod("sseccuS");
            StatefulLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatefulLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessLocal.echo(expected);
            StatefulLocalBusinessIntfcTests.assertSame((String)"pass by reference", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessLocal.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatefulLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulLocalBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessLocal.businessMethod("sseccuS");
            StatefulLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatefulLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessLocal.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            StatefulLocalBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatefulLocalBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatefulLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulLocalBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessLocal.remove();
        StatefulLocalBusinessIntfcTests.assertNotNull((Object)obj);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

