/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.singleton.BasicSingletonBusinessRemote;
import org.apache.openejb.test.singleton.SingletonTestClient;

public class SingletonRemoteBusinessIntfcTests
extends SingletonTestClient {
    private BasicSingletonBusinessRemote businessRemote;

    public SingletonRemoteBusinessIntfcTests() {
        super("RemoteBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHomeBusinessRemote");
        SingletonRemoteBusinessIntfcTests.assertNotNull((Object)obj);
        SingletonRemoteBusinessIntfcTests.assertTrue((String)"instance of BasicSingletonBusinessRemote", (boolean)(obj instanceof BasicSingletonBusinessRemote));
        this.businessRemote = (BasicSingletonBusinessRemote)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessRemote.businessMethod("sseccuS");
            SingletonRemoteBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessRemote.echo(expected);
            SingletonRemoteBusinessIntfcTests.assertEquals((Object)expected, (Object)actual);
            SingletonRemoteBusinessIntfcTests.assertNotSame((String)"pass by value", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessRemote.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            SingletonRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonRemoteBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessRemote.businessMethod("sseccuS");
            SingletonRemoteBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            SingletonRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessRemote.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            SingletonRemoteBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            SingletonRemoteBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            SingletonRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonRemoteBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessRemote.remove();
        SingletonRemoteBusinessIntfcTests.assertNotNull((Object)obj);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

