/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import java.rmi.RemoteException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class SingletonPojoRemoteIntrfcTests
extends BasicSingletonTestClient {
    public SingletonPojoRemoteIntrfcTests() {
        super("PojoRemoteIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHome");
        this.ejbHome = (BasicSingletonHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            SingletonPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonPojoRemoteIntrfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            SingletonPojoRemoteIntrfcTests.assertTrue((boolean)true);
            return;
        }
        catch (Throwable e) {
            SingletonPojoRemoteIntrfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonPojoRemoteIntrfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            SingletonPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            SingletonPojoRemoteIntrfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            SingletonPojoRemoteIntrfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            SingletonPojoRemoteIntrfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            SingletonPojoRemoteIntrfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonPojoRemoteIntrfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void test05_invokeAfterSystemException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            SingletonPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonPojoRemoteIntrfcTests.fail((String)"The business method should have been executed.");
        }
        catch (Throwable e) {
            SingletonPojoRemoteIntrfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

