/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.singleton.BasicSingletonBusinessLocal;
import org.apache.openejb.test.singleton.SingletonTestClient;

public class SingletonLocalBusinessIntfcTests
extends SingletonTestClient {
    private BasicSingletonBusinessLocal businessLocal;

    public SingletonLocalBusinessIntfcTests() {
        super("LocalBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHomeBusinessLocal");
        SingletonLocalBusinessIntfcTests.assertNotNull((Object)obj);
        SingletonLocalBusinessIntfcTests.assertTrue((String)"instance of BasicSingletonBusinessLocal", (boolean)(obj instanceof BasicSingletonBusinessLocal));
        this.businessLocal = (BasicSingletonBusinessLocal)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessLocal.businessMethod("sseccuS");
            SingletonLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessLocal.echo(expected);
            SingletonLocalBusinessIntfcTests.assertSame((String)"pass by reference", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessLocal.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            SingletonLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonLocalBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessLocal.businessMethod("sseccuS");
            SingletonLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            SingletonLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessLocal.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            SingletonLocalBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            SingletonLocalBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            SingletonLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonLocalBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessLocal.remove();
        SingletonLocalBusinessIntfcTests.assertNotNull((Object)obj);
    }
}

