/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.openejb.test.NamedTestCase;
import org.apache.openejb.test.TestManager;

public abstract class AbstractCMRTest
extends NamedTestCase {
    private TransactionManager transactionManager;
    protected DataSource ds;
    protected InitialContext initialContext;

    public AbstractCMRTest(String name) {
        super("Entity.CMR." + name);
    }

    protected synchronized void beginTransaction() throws Exception {
        this.transactionManager.begin();
    }

    protected synchronized void completeTransaction() throws SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        int status = this.transactionManager.getStatus();
        if (status == 0) {
            this.transactionManager.commit();
        } else if (status != 6) {
            this.transactionManager.rollback();
        } else {
            throw new IllegalStateException("tx status: " + status);
        }
    }

    @Override
    protected synchronized void setUp() throws Exception {
        super.setUp();
        Properties properties = TestManager.getServer().getContextEnvironment();
        this.initialContext = new InitialContext(properties);
        InitialContext jndiContext = new InitialContext();
        this.transactionManager = (TransactionManager)jndiContext.lookup("java:openejb/TransactionManager");
        try {
            this.ds = (DataSource)jndiContext.lookup("java:openejb/Resource/My DataSource");
        }
        catch (NamingException e) {
            this.ds = (DataSource)jndiContext.lookup("java:openejb/Resource/Default JDBC Database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpTable(DataSource ds, String table) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = ds.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            ResultSetMetaData setMetaData = resultSet.getMetaData();
            int columnCount = setMetaData.getColumnCount();
            while (resultSet.next()) {
                StringBuilder row = new StringBuilder();
                for (int i = 1; i <= columnCount; ++i) {
                    if (i > 1) {
                        row.append(", ");
                    }
                    String name = setMetaData.getColumnName(i);
                    Object value = resultSet.getObject(i);
                    row.append(name).append("=").append(value);
                }
                System.out.println(row);
            }
        }
        catch (Throwable throwable) {
            AbstractCMRTest.close(resultSet);
            AbstractCMRTest.close(statement);
            AbstractCMRTest.close(connection);
            throw throwable;
        }
        AbstractCMRTest.close(resultSet);
        AbstractCMRTest.close(statement);
        AbstractCMRTest.close(connection);
    }

    protected static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

