/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestResult;
import org.apache.openejb.test.ResultPrinter;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.TomcatRemoteTestServer;

public class TestRunner
extends junit.textui.TestRunner {
    private static final String helpBase = "/META-INF/org.apache.openejb.cli/";

    public TestRunner() {
        this(System.out);
    }

    public TestRunner(PrintStream writer) {
        this(new ResultPrinter(writer));
    }

    public TestRunner(ResultPrinter printer) {
        super((junit.textui.ResultPrinter)printer);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TestRunner.printHelp();
        } else {
            if (args[0].equals("--help")) {
                TestRunner.printHelp();
                return;
            }
            if (args[0].equals("local")) {
                TestRunner.runLocalTests();
            } else if (args[0].equals("remote")) {
                TestRunner.runRemoteTests();
            } else if (args[0].equals("http")) {
                TestRunner.runRemoteHttpTests();
            } else if (args[0].equals("tomcat")) {
                TestRunner.runTomcatRemoteHttpTests();
            } else {
                TestRunner.printHelp();
                return;
            }
            try {
                TestRunner aTestRunner = new TestRunner();
                TestResult r = aTestRunner.start(new String[]{"org.apache.openejb.test.ClientTestSuite"});
                System.out.println("");
                System.out.println("_________________________________________________");
                System.out.println("CLIENT JNDI PROPERTIES");
                Properties env = TestManager.getServer().getContextEnvironment();
                for (Map.Entry<Object, Object> entry : env.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    System.out.println(key + " = " + value);
                }
                System.out.println("_________________________________________________");
                if (!r.wasSuccessful()) {
                    System.exit(1);
                }
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(2);
            }
        }
    }

    private static void runLocalTests() {
        TestRunner.setDefault("openejb.test.server", "org.apache.openejb.test.IvmTestServer");
        TestRunner.setDefault("openejb.test.database", "org.apache.openejb.test.HsqldbTestDatabase");
        System.out.println("_________________________________________________");
        System.out.println("|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|\n");
        System.out.println("Running EJB compliance tests on IntraVM Server");
        System.out.println("_________________________________________________");
    }

    private static void setDefault(String key, String value) {
        value = System.getProperty(key, value);
        System.setProperty(key, value);
    }

    private static void runRemoteTests() {
        TestRunner.setDefault("openejb.test.server", "org.apache.openejb.test.RemoteTestServer");
        TestRunner.setDefault("openejb.test.database", "org.apache.openejb.test.HsqldbTestDatabase");
        System.out.println("_________________________________________________");
        System.out.println("|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|\n");
        System.out.println("Running EJB compliance tests on Remote Server");
        System.out.println("_________________________________________________");
    }

    private static void runRemoteHttpTests() {
        TestRunner.setDefault("openejb.test.server", "org.apache.openejb.test.RemoteHttpTestServer");
        TestRunner.setDefault("openejb.test.database", "org.apache.openejb.test.HsqldbTestDatabase");
        System.out.println("_________________________________________________");
        System.out.println("|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|\n");
        System.out.println("Running EJB compliance tests on HTTP/Remote Server");
        System.out.println("_________________________________________________");
    }

    private static void runTomcatRemoteHttpTests() {
        TestRunner.setDefault("openejb.test.server", TomcatRemoteTestServer.class.getName());
        TestRunner.setDefault("openejb.test.database", "org.apache.openejb.test.HsqldbTestDatabase");
        TestRunner.setDefault("openejb.test.servlets", "true");
        System.out.println("_________________________________________________");
        System.out.println("|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|\n");
        System.out.println("Running EJB compliance tests on HTTP/Tomcat Server");
        System.out.println("_________________________________________________");
    }

    private static void printHelp() {
        Object header = "OpenEJB Compliance Tests ";
        try {
            InputStream is = TestRunner.class.getResourceAsStream("/META-INF/openejb-version.properties");
            Properties versionInfo = new Properties();
            versionInfo.load(is);
            header = (String)header + versionInfo.get("version");
        }
        catch (IOException is) {
            // empty catch block
        }
        System.out.println((String)header);
        try {
            InputStream in = TestRunner.class.getResourceAsStream("/META-INF/org.apache.openejb.cli/test.help");
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult start(String[] args) throws Exception {
        TestResult result = null;
        try {
            TestManager.init(null);
            TestManager.start();
        }
        catch (Exception e) {
            System.out.println("Cannot initialize the test environment: " + e.getClass().getName() + " " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        try {
            result = super.start(args);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                TestManager.stop();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static final class Pipe
    implements Runnable {
        private final InputStream is;
        private final OutputStream out;

        private Pipe(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int i = this.is.read();
                this.out.write(i);
                while (i != -1) {
                    i = this.is.read();
                    this.out.write(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

