/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.RemoteException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessPojoRemoteIntrfcTests
extends BasicStatelessTestClient {
    public StatelessPojoRemoteIntrfcTests() {
        super("PojoRemoteIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessPojoHome");
        this.ejbHome = (BasicStatelessHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatelessPojoRemoteIntrfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            StatelessPojoRemoteIntrfcTests.assertTrue((boolean)true);
            return;
        }
        catch (Throwable e) {
            StatelessPojoRemoteIntrfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        StatelessPojoRemoteIntrfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatelessPojoRemoteIntrfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            StatelessPojoRemoteIntrfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatelessPojoRemoteIntrfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessPojoRemoteIntrfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        StatelessPojoRemoteIntrfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void test05_invokeAfterSystemException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            StatelessPojoRemoteIntrfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatelessPojoRemoteIntrfcTests.fail((String)"The business method should have been executed.");
        }
        catch (Throwable e) {
            StatelessPojoRemoteIntrfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

