/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import jakarta.ejb.EJBObject;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulHandleTests
extends BasicStatefulTestClient {
    public StatefulHandleTests() {
        super("Handle.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)obj;
        this.ejbObject = this.ejbHome.createObject("Fourth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    public void test01_getEJBObject() {
        try {
            EJBObject object = this.ejbHandle.getEJBObject();
            StatefulHandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
        }
        catch (Exception e) {
            StatefulHandleTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_EJBHome_remove() {
        try {
            this.ejbHome.remove(this.ejbHandle);
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                StatefulHandleTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                StatefulHandleTests.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            StatefulHandleTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

