/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.EJBException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.singleton.BasicSingletonLocalHome;
import org.apache.openejb.test.singleton.BasicSingletonLocalTestClient;

public class SingletonLocalIntfcTests
extends BasicSingletonLocalTestClient {
    public SingletonLocalIntfcTests() {
        super("LocalIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHomeLocal");
        this.ejbLocalHome = (BasicSingletonLocalHome)obj;
        this.ejbLocalObject = this.ejbLocalHome.create();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            SingletonLocalIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonLocalIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbLocalObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            SingletonLocalIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        SingletonLocalIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            SingletonLocalIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            SingletonLocalIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbLocalObject.throwSystemException_NullPointer();
        }
        catch (EJBException e) {
            SingletonLocalIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)((Object)e));
            SingletonLocalIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + e.getCausedByException().getClass().getName()), (boolean)(e.getCausedByException() instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            SingletonLocalIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        SingletonLocalIntfcTests.fail((String)"An EJBException encapsulating a NullPointerException should have been thrown.");
    }

    public void test05_invokeAfterSystemException() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            SingletonLocalIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            SingletonLocalIntfcTests.fail((String)"The business method should have been executed.");
        }
        catch (Throwable e) {
            SingletonLocalIntfcTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

