/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.ejb.EJBMetaData;
import jakarta.ejb.Handle;
import jakarta.ejb.HomeHandle;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.test.NamedTestCase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.singleton.ContainerTxSingletonHome;
import org.apache.openejb.test.singleton.ContainerTxSingletonObject;

public class SingletonContainerTxTests
extends NamedTestCase {
    public static final String jndiEJBHomeEntry = "client/tests/singleton/ContainerManagedTransactionTests/EJBHome";
    protected ContainerTxSingletonHome ejbHome;
    protected ContainerTxSingletonObject ejbObject;
    protected EJBMetaData ejbMetaData;
    protected HomeHandle ejbHomeHandle;
    protected Handle ejbHandle;
    protected Integer ejbPrimaryKey;
    protected InitialContext initialContext;

    public SingletonContainerTxTests() {
        super("Singleton.ContainerManagedTransaction.");
    }

    @Override
    protected void setUp() throws Exception {
        Properties properties = TestManager.getServer().getContextEnvironment();
        this.initialContext = new InitialContext(properties);
        Object obj = this.initialContext.lookup(jndiEJBHomeEntry);
        this.ejbHome = (ContainerTxSingletonHome)obj;
        this.ejbObject = this.ejbHome.create();
        TestManager.getDatabase().createAccountTable();
    }

    @Override
    protected void tearDown() throws Exception {
        TestManager.getDatabase().dropAccountTable();
    }

    public void test01_txMandatory_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test01_txMandatory_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test01_txMandatory_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod("ping");
            SingletonContainerTxTests.assertEquals((String)"The method invocation was invalid.", (Object)"ping", (Object)actual);
        }
        catch (Exception e) {
            SingletonContainerTxTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

