/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import org.apache.openejb.test.beans.TimerSync;
import org.apache.openejb.test.object.OperationsPolicy;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class BMTSingletonAllowedOperationsTests
extends BasicSingletonTestClient {
    protected TimerSync timerSync;

    public BMTSingletonAllowedOperationsTests() {
        super("BMTAllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BeanManagedBasicSingletonHome");
        this.ejbHome = (BasicSingletonHome)obj;
        this.ejbObject = this.ejbHome.createObject();
        this.ejbHandle = this.ejbObject.getHandle();
        this.timerSync = (TimerSync)this.initialContext.lookup("TimerSyncBeanBusinessRemote");
        this.ejbObject.businessMethod("let's go!");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            BMTSingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTSingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTSingletonAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            BMTSingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTSingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTSingletonAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            BMTSingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTSingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTSingletonAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            BMTSingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTSingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTSingletonAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void _test05_ejbTimeout() {
        try {
            this.ejbObject.scheduleTimer("BmtSingletonAllowedOperationsTests");
            this.timerSync.waitFor("BmtSingletonAllowedOperationsTests");
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(6);
            policy.allow(5);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbTimeout");
            BMTSingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BMTSingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BMTSingletonAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

