/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import org.apache.openejb.test.mdb.BasicMdbObject;
import org.apache.openejb.test.mdb.MdbProxy;
import org.apache.openejb.test.mdb.MdbTestClient;
import org.apache.openejb.test.object.OperationsPolicy;

public class MdbAllowedOperationsTests
extends MdbTestClient {
    protected BasicMdbObject basicMdbObject;

    public MdbAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Destination destination = (Destination)this.initialContext.lookup("client/tests/messagedriven/mdb/BasicMdb");
        this.basicMdbObject = (BasicMdbObject)MdbProxy.newProxyInstance(BasicMdbObject.class, (ConnectionFactory)this.connectionFactory, (Destination)destination);
        this.basicMdbObject.businessMethod("foo");
    }

    @Override
    protected void tearDown() throws Exception {
        MdbProxy.destroyProxy((Object)this.basicMdbObject);
        super.tearDown();
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("setMessageDrivenContext");
            MdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            MdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            MdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("ejbCreate");
            MdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            MdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            MdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("ejbRemove");
            MdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            MdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            MdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(3);
            policy.allow(1);
            policy.allow(2);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("businessMethod");
            MdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            MdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            MdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

