/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import org.apache.openejb.test.mdb.BasicMdbObject;
import org.apache.openejb.test.mdb.MdbProxy;
import org.apache.openejb.test.mdb.MdbTestClient;
import org.apache.openejb.test.object.OperationsPolicy;

public class BmtMdbAllowedOperationsTests
extends MdbTestClient {
    protected BasicMdbObject basicMdbObject;

    public BmtMdbAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Destination destination = (Destination)this.initialContext.lookup("Basic BMT Mdb Bean");
        this.basicMdbObject = (BasicMdbObject)MdbProxy.newProxyInstance(BasicMdbObject.class, (ConnectionFactory)this.connectionFactory, (Destination)destination);
        this.basicMdbObject.businessMethod("foo");
    }

    @Override
    protected void tearDown() throws Exception {
        MdbProxy.destroyProxy((Object)this.basicMdbObject);
        super.tearDown();
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("setMessageDrivenContext");
            BmtMdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BmtMdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BmtMdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(11);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("ejbCreate");
            BmtMdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BmtMdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BmtMdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(5);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("ejbRemove");
            BmtMdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BmtMdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BmtMdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(5);
            policy.allow(1);
            policy.allow(2);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.basicMdbObject.getAllowedOperationsReport("businessMethod");
            BmtMdbAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            BmtMdbAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            BmtMdbAllowedOperationsTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

