/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.mdb.BasicMdbObject;
import org.apache.openejb.test.mdb.MdbProxy;
import org.apache.openejb.test.mdb.MdbTestClient;

public class BasicMdbTests
extends MdbTestClient {
    protected BasicMdbObject basicMdbObject;

    public BasicMdbTests() {
        super("BasicMdb.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Destination destination = (Destination)this.initialContext.lookup("client/tests/messagedriven/mdb/BasicMdb");
        this.basicMdbObject = (BasicMdbObject)MdbProxy.newProxyInstance(BasicMdbObject.class, (ConnectionFactory)this.connectionFactory, (Destination)destination);
    }

    @Override
    protected void tearDown() throws Exception {
        MdbProxy.destroyProxy((Object)this.basicMdbObject);
        super.tearDown();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.basicMdbObject.businessMethod("sseccuS");
            BasicMdbTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            e.printStackTrace();
            BasicMdbTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void Xtest02_throwApplicationException() {
        try {
            this.basicMdbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            BasicMdbTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        BasicMdbTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.basicMdbObject.businessMethod("sseccuS");
            BasicMdbTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            e.printStackTrace();
            BasicMdbTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }

    public void Xtest04_throwSystemException() {
        try {
            this.basicMdbObject.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            BasicMdbTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            BasicMdbTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            BasicMdbTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
        BasicMdbTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
        try {
            this.basicMdbObject.businessMethod("This refernce is invalid");
            BasicMdbTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (Exception exception) {
        }
        catch (Throwable e) {
            BasicMdbTests.fail((String)("Received Exception " + String.valueOf(e.getClass()) + " : " + e.getMessage()));
        }
    }
}

