/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.test.TestServer;

public class TomcatRemoteTestServer
implements TestServer {
    private Properties properties;
    private String serverUri;

    @Override
    public void init(Properties props) {
        this.properties = props;
        this.serverUri = System.getProperty("openejb.server.uri", "http://127.0.0.1:8080/tomee/ejb");
        if (!this.serverUri.startsWith("http:")) {
            throw new IllegalStateException("TomcatRemoteTestServer requires that openejb.server.uri property starts with http:");
        }
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", this.serverUri);
    }

    @Override
    public void start() {
        if (this.connect()) {
            return;
        }
        if (!this.connect(20)) {
            throw new RuntimeException("Failed to connect");
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Properties getContextEnvironment() {
        return (Properties)this.properties.clone();
    }

    private boolean connect() {
        return this.connect(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(int tries) {
        InputStream is = null;
        try {
            URL url = new URL(this.serverUri);
            is = url.openStream();
        }
        catch (Exception e) {
            if (--tries < 1) {
                boolean bl = false;
                return bl;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            boolean bl = this.connect(tries);
            return bl;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return true;
    }
}

