/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.test.TestDatabase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.beans.Database;
import org.apache.openejb.test.beans.DatabaseHome;

public class DerbyTestDatabase
implements TestDatabase {
    protected Database database;
    protected InitialContext initialContext;
    private static String _createAccount = "CREATE TABLE account ( ssn VARCHAR(25), first_name VARCHAR(256), last_name VARCHAR(256), balance integer)";
    private static String _dropAccount = "DROP TABLE account";
    private static String _createEntity = "CREATE TABLE entity ( id integer GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), first_name VARCHAR(256), last_name VARCHAR(256) )";
    private static String _dropEntity = "DROP TABLE entity";

    @Override
    public void createEntityTable() throws SQLException {
        try {
            try {
                this.database.execute(_dropEntity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.database.execute(_createEntity);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create entity table: " + re.getMessage(), _createEntity);
        }
    }

    @Override
    public void dropEntityTable() throws SQLException {
        try {
            this.database.execute(_dropEntity);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Unable to drop entity table: " + re.getMessage(), _dropEntity);
        }
    }

    @Override
    public void createAccountTable() throws SQLException {
        try {
            try {
                this.database.execute(_dropAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.database.execute(_createAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create account table: " + re.getMessage(), _createAccount);
        }
    }

    @Override
    public void dropAccountTable() throws SQLException {
        try {
            this.database.execute(_dropAccount);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot drop account table: " + re.getMessage(), _dropAccount);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        try {
            Properties properties = TestManager.getServer().getContextEnvironment();
            this.initialContext = new InitialContext(properties);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Cannot create initial context: " + e.getClass().getName() + " " + e.getMessage()).initCause(e);
        }
        Object obj = null;
        DatabaseHome databaseHome = null;
        try {
            obj = this.initialContext.lookup("client/tools/DatabaseHome");
            databaseHome = (DatabaseHome)obj;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find 'client/tools/DatabaseHome': " + e.getClass().getName() + " " + e.getMessage());
        }
        try {
            this.database = databaseHome.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start database: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    @Override
    public void stop() throws IllegalStateException {
    }

    @Override
    public void init(Properties props) throws IllegalStateException {
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

