/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.context.RequestInfos;
import org.apache.openejb.server.ejbd.EjbServer;

public class ServerServlet
extends HttpServlet {
    private static final String ACTIVATED_INIT_PARAM = "activated";
    private EjbServer ejbServer;
    private boolean activated = SystemInstance.get().isDefaultProfile();

    public void init(ServletConfig config) {
        this.ejbServer = (EjbServer)SystemInstance.get().getComponent(EjbServer.class);
        String activatedStr = config.getInitParameter(ACTIVATED_INIT_PARAM);
        this.activated = activatedStr != null ? Boolean.parseBoolean(activatedStr) : Boolean.parseBoolean(System.getProperty(((Object)((Object)this)).getClass().getName() + '.' + ACTIVATED_INIT_PARAM, "true"));
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.activated) {
            response.getWriter().write("");
            return;
        }
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        try {
            RequestInfos.initRequestInfo((HttpServletRequest)request);
            this.ejbServer.service((InputStream)in, (OutputStream)out);
        }
        catch (ServiceException e) {
            throw new ServletException("ServerService error: " + this.ejbServer.getClass().getName() + " -- " + e.getMessage(), (Throwable)e);
        }
        finally {
            RequestInfos.clearRequestInfo();
        }
    }
}

