/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.Proxys;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.EmbeddedServletContext;
import org.apache.openejb.server.httpd.FilterListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.LightweightWebAppBuilderListenerExtractor;
import org.apache.openejb.server.httpd.ServletSessionAdapter;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.web.LightweightWebAppBuilder;

public class HttpListenerRegistry
implements HttpListener {
    private final Map<String, HttpListener> registry = new LinkedHashMap<String, HttpListener>();
    private final Map<String, Collection<HttpListener>> filterRegistry = new LinkedHashMap<String, Collection<HttpListener>>();
    private final ThreadLocal<FilterListener> currentFilterListener = new ThreadLocal();
    private final ThreadLocal<HttpRequest> request = new ThreadLocal();
    private final ClassLoader defaultClassLoader;
    private final File[] resourceBases;
    private final Map<String, String> defaultContextTypes = new HashMap<String, String>();
    private final String welcomeFile = SystemInstance.get().getProperty("openejb.http.welcome", "index.html");
    private final Map<String, byte[]> cache = new HashMap<String, byte[]>();
    private final boolean cacheResources = "true".equals(SystemInstance.get().getProperty("openejb.http.resource.cache", "false"));

    public HttpListenerRegistry() {
        HttpRequestImpl mock = null;
        SystemInstance systemInstance = SystemInstance.get();
        if ("true".equalsIgnoreCase(systemInstance.getProperty("openejb.http.mock-request", "false"))) {
            HttpRequestImpl mockRequest = null;
            try {
                mockRequest = new HttpRequestImpl(new URI("http://mock/"));
                mockRequest.parseURI(new StringTokenizer("mock\n"));
                mock = mockRequest;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (systemInstance.getComponent(HttpServletRequest.class) == null) {
            systemInstance.setComponent(HttpServletRequest.class, Proxys.threadLocalProxy(HttpServletRequest.class, this.request, mock));
        }
        if (systemInstance.getComponent(HttpSession.class) == null) {
            javax.servlet.http.HttpSession delegate = mock != null ? mock.getSession() : null;
            systemInstance.setComponent(javax.servlet.http.HttpSession.class, (Object)Proxys.threadLocalRequestSessionProxy(this.request, (javax.servlet.http.HttpSession)new ServletSessionAdapter(delegate){

                @Override
                public void invalidate() {
                    Object web = AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.AppOrWebContextTransformer.INSTANCE);
                    if (WebContext.class.isInstance(web)) {
                        this.doInvokeSpecificListeners(((WebContext)WebContext.class.cast(web)).getContextRoot());
                    } else if (AppContext.class.isInstance(web)) {
                        this.doInvokeSpecificListeners(((AppContext)AppContext.class.cast(web)).getId());
                    }
                    super.invalidate();
                }

                private void doInvokeSpecificListeners(String web) {
                    WebAppBuilder wab = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
                    if (LightweightWebAppBuilder.class.isInstance(wab)) {
                        Collection<HttpSessionListener> listeners = LightweightWebAppBuilderListenerExtractor.findByTypeForContext(web, HttpSessionListener.class);
                        HttpSessionEvent event = new HttpSessionEvent((javax.servlet.http.HttpSession)this);
                        for (HttpSessionListener o : listeners) {
                            try {
                                o.sessionDestroyed(event);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }));
        }
        if (systemInstance.getComponent(ServletContext.class) == null) {
            systemInstance.setComponent(ServletContext.class, (Object)new EmbeddedServletContext());
        }
        this.defaultClassLoader = ParentClassLoaderFinder.Helper.get();
        String resourceFolderPaths = SystemInstance.get().getProperty("openejb.embedded.http.resources");
        LinkedList<File> resources = new LinkedList<File>();
        if (resourceFolderPaths != null) {
            for (String path : resourceFolderPaths.split(" , ")) {
                if (path.isEmpty()) continue;
                resources.add(new File(path));
            }
        }
        this.resourceBases = resources.toArray(new File[resources.size()]);
        this.defaultContextTypes.put("html", "text/html");
        this.defaultContextTypes.put("html", "text/html");
        this.defaultContextTypes.put("css", "text/css");
        this.defaultContextTypes.put("txt", "text/plain");
        this.defaultContextTypes.put("xml", "application/xml");
        this.defaultContextTypes.put("xsl", "application/xml");
        this.defaultContextTypes.put("js", "application/javascript");
        this.defaultContextTypes.put("gif", "image/gif");
        this.defaultContextTypes.put("jpeg", "image/jpeg");
        this.defaultContextTypes.put("jpg", "image/jpeg");
        this.defaultContextTypes.put("png", "image/png");
        this.defaultContextTypes.put("tiff", "image/tiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        HashMap<String, Collection<HttpListener>> filters;
        String path = !HttpRequestImpl.class.isInstance(request) ? request.getRequestURI() : this.getRequestHandledPath(request);
        FilterListener currentFL = this.currentFilterListener.get();
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            filters = new HashMap<String, Collection<HttpListener>>(this.filterRegistry);
        }
        HttpRequest registered = this.request.get();
        boolean reset = registered == null;
        try {
            String servletPath;
            boolean bl;
            HashMap<String, HttpListener> listeners;
            if (reset) {
                this.request.set(request);
            }
            boolean lastWasCurrent = false;
            for (Map.Entry entry : filters.entrySet()) {
                String pattern = (String)entry.getKey();
                for (HttpListener listener : (Collection)entry.getValue()) {
                    if ((lastWasCurrent || currentFL == null) && path.matches(pattern)) {
                        listener.onMessage(request, response);
                        return;
                    }
                    lastWasCurrent = listener == currentFL;
                }
            }
            Map<String, HttpListener> map2 = this.registry;
            synchronized (map2) {
                listeners = new HashMap<String, HttpListener>(this.registry);
            }
            boolean bl2 = false;
            for (Map.Entry entry : listeners.entrySet()) {
                String pattern = (String)entry.getKey();
                if (!path.matches(pattern) && !path.equals(pattern)) continue;
                if (pattern.contains("/.*\\.") && HttpRequestImpl.class.isInstance(request)) {
                    ((HttpRequestImpl)HttpRequestImpl.class.cast(request)).noPathInfo();
                }
                ((HttpListener)entry.getValue()).onMessage(request, response);
                bl = true;
                break;
            }
            if (!bl && (servletPath = request.getServletPath()) != null) {
                int dot;
                void var12_22;
                URL uRL = ((ServletContext)SystemInstance.get().getComponent(ServletContext.class)).getResource(servletPath);
                if (uRL != null) {
                    this.serveResource(servletPath, response, uRL);
                } else {
                    String pathWithoutSlash = "/".equals(path) || "".equals(servletPath) || "/".equals(servletPath) ? this.welcomeFile : (servletPath.startsWith("/") ? servletPath.substring(1) : servletPath);
                    URL uRL2 = this.defaultClassLoader.getResource("META-INF/resources/" + pathWithoutSlash);
                    if (uRL2 != null) {
                        this.serveResource(servletPath, response, uRL2);
                    } else if (this.resourceBases.length > 0) {
                        for (File f : this.resourceBases) {
                            File file = new File(f, pathWithoutSlash);
                            if (!file.isFile()) continue;
                            URL uRL3 = file.toURI().toURL();
                            this.serveResource(servletPath, response, uRL3);
                            break;
                        }
                    }
                }
                if (var12_22 != null && (dot = servletPath.lastIndexOf(46)) > 0 && dot < servletPath.length() - 1) {
                    String ext = servletPath.substring(dot + 1);
                    String ct = this.defaultContextTypes.get(ext);
                    if (ct != null) {
                        response.setContentType(ct);
                    } else {
                        String uct = SystemInstance.get().getProperty("openejb.embedded.http.content-type." + ext);
                        if (uct != null) {
                            response.setContentType(uct);
                        }
                    }
                }
            }
        }
        finally {
            if (currentFL == null) {
                this.currentFilterListener.set(null);
            }
            if (reset) {
                this.request.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveResource(String key, HttpResponse response, URL url) throws IOException {
        if (this.cacheResources) {
            byte[] value = this.cache.get(key);
            if (value == null) {
                InputStream from = url.openStream();
                try {
                    ByteArrayOutputStream to = new ByteArrayOutputStream();
                    IO.copy((InputStream)from, (OutputStream)to);
                    value = to.toByteArray();
                    this.cache.put(key, value);
                }
                finally {
                    IO.close((Closeable)from);
                }
            }
            response.getOutputStream().write(value);
        } else {
            InputStream from = url.openStream();
            try {
                IO.copy((InputStream)from, (OutputStream)response.getOutputStream());
            }
            finally {
                IO.close((Closeable)from);
            }
        }
    }

    private String getRequestHandledPath(HttpRequest request) {
        String servletPath = request.getServletPath();
        return request.getContextPath() + (!servletPath.startsWith("/") ? "/" : "") + servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpListener(HttpListener listener, String regex) {
        Map<String, HttpListener> map = this.registry;
        synchronized (map) {
            this.registry.put(regex, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpListener removeHttpListener(String regex) {
        HttpListener listener;
        Map<String, HttpListener> map = this.registry;
        synchronized (map) {
            listener = this.registry.remove(regex);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpFilter(HttpListener listener, String regex) {
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            if (!this.filterRegistry.containsKey(regex)) {
                this.filterRegistry.put(regex, new ArrayList());
            }
            this.filterRegistry.get(regex).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HttpListener> removeHttpFilter(String regex) {
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            return this.filterRegistry.remove(regex);
        }
    }

    public void setOrigin(FilterListener origin) {
        if (origin == null) {
            this.currentFilterListener.remove();
        } else {
            this.currentFilterListener.set(origin);
        }
    }
}

