/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.server.cli.command.ScriptCommand;

@Command(name="script file", usage="script file <path>", description="execute script code contained in a file in the specifid language. ejb can be accessed through their ejb name in the script. The extension is used to detect the file format.")
public class ScriptFileCommand
extends ScriptCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String cmd) {
        try {
            this.parse(cmd);
        }
        catch (IllegalArgumentException iae) {
            this.streamManager.writeErr("script cmd " + cmd + " can't be parsed");
            return;
        }
        File file = new File(this.script);
        if (!file.exists()) {
            this.streamManager.writeErr("script file " + file.getPath() + " doesn't exist");
            return;
        }
        StringBuilder builder = new StringBuilder(1024);
        builder.append("script ").append(this.language).append(" ");
        BufferedReader reader = null;
        try {
            int numRead;
            reader = new BufferedReader(new FileReader(file));
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                builder.append(readData);
                buf = new char[1024];
            }
        }
        catch (Exception e) {
            this.streamManager.writeErr(e);
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.execute(builder.toString());
    }

    private void parse(String cmd) {
        this.script = cmd;
        int dotIdx = this.script.lastIndexOf(".");
        if (dotIdx < 0) {
            throw new IllegalArgumentException("bad syntax, see help");
        }
        this.language = this.script.substring(dotIdx + 1, this.script.length());
    }
}

