/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.bonecp;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.managed.xa.ManagedXADataSource;
import org.apache.openejb.resource.jdbc.plugin.DataSourcePlugin;
import org.apache.openejb.resource.jdbc.pool.PoolDataSourceCreator;
import org.apache.openejb.resource.jdbc.pool.XADataSourceResource;
import org.apache.openejb.util.Strings;
import org.apache.xbean.recipe.ObjectRecipe;

public class BoneCPDataSourceCreator
extends PoolDataSourceCreator {
    protected void doDestroy(CommonDataSource dataSource) throws Throwable {
        ((BoneCPDataSource)dataSource).close();
    }

    public DataSource pool(String name, DataSource ds, Properties properties) {
        BoneCPDataSource dataSourceProvidedPool = this.createPool(properties);
        dataSourceProvidedPool.setDatasourceBean(ds);
        if (dataSourceProvidedPool.getPoolName() == null) {
            dataSourceProvidedPool.setPoolName(name);
        }
        return dataSourceProvidedPool;
    }

    public CommonDataSource pool(String name, String driver, Properties properties) {
        String xa;
        BoneCPDataSource pool = this.createPool(properties);
        if (pool.getDriverClass() == null) {
            pool.setDriverClass(driver);
        }
        if (pool.getPoolName() == null) {
            pool.setPoolName(name);
        }
        if ((xa = (String)String.class.cast(properties.remove("XaDataSource"))) != null) {
            XADataSource xaDs = XADataSourceResource.proxy((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)xa);
            pool.setDatasourceBean((DataSource)new ManagedXADataSource((CommonDataSource)xaDs, OpenEJB.getTransactionManager(), (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class)));
        }
        return pool;
    }

    private BoneCPDataSource createPool(Properties properties) {
        BoneCPConfig config;
        try {
            config = new BoneCPConfig(this.prefixedProps(properties));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        BoneCPDataSource dataSourceProvidedPool = new BoneCPDataSource(config);
        this.recipes.put(dataSourceProvidedPool, new ObjectRecipe(BoneCPDataSource.class.getName()));
        return dataSourceProvidedPool;
    }

    private Properties prefixedProps(Properties properties) {
        String cipher;
        String currentUrl;
        if (properties.containsKey("url")) {
            properties.setProperty("url", properties.getProperty("url"));
        }
        if ((currentUrl = properties.getProperty("jdbcUrl")) != null) {
            try {
                String newUrl;
                DataSourcePlugin helper = BasicDataSourceUtil.getDataSourcePlugin((String)currentUrl);
                if (helper != null && !currentUrl.equals(newUrl = helper.updatedUrl(currentUrl))) {
                    properties.setProperty("jdbcUrl", newUrl);
                }
            }
            catch (SQLException helper) {
                // empty catch block
            }
        }
        if ((cipher = properties.getProperty("PasswordCipher")) == null || "PlainText".equals(cipher)) {
            properties.remove("PasswordCipher");
        }
        Properties prefixedProps = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String suffix = Strings.lcfirst((String)((String)entry.getKey()));
            if (!suffix.startsWith("bonecp.")) {
                prefixedProps.put("bonecp." + suffix, entry.getValue());
                continue;
            }
            prefixedProps.put(suffix, entry.getValue());
        }
        return prefixedProps;
    }
}

