/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Properties;
import org.apache.activemq.broker.BrokerService;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;

public class BrokerServer
implements ServerService,
SelfManaging {
    private BrokerService broker;
    private int port = 1527;
    private boolean disabled;
    private InetAddress host;

    public void init(Properties properties) throws Exception {
        String port = properties.getProperty("port", "1527");
        String bind = properties.getProperty("bind");
        String disabled = properties.getProperty("disabled");
        this.port = Integer.parseInt(port);
        this.disabled = Boolean.parseBoolean(disabled);
        this.host = InetAddress.getByName(bind);
        if (this.disabled) {
            return;
        }
        URI uri = new URI("tcp", null, bind, this.port, null, null, null);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.addConnector(uri);
    }

    public void start() throws ServiceException {
        if (this.disabled) {
            return;
        }
        try {
            this.broker.start();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        if (this.broker == null) {
            return;
        }
        try {
            this.broker.stop();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.broker = null;
        }
    }

    public void service(InputStream inputStream, OutputStream outputStream) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getName() {
        return "activemq";
    }

    public String getIP() {
        return this.host.getHostAddress();
    }

    public int getPort() {
        return this.port;
    }
}

