/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.customizer.monkey.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.maven.plugin.customizer.monkey.classloader.ClassLoaderFactory;
import org.apache.openejb.maven.plugin.customizer.monkey.index.Item;

public class FileIndexer {
    private final ClassLoader loader;
    private final File binaries;
    private final String binaryRoot;
    private final String ignore;
    private final ClassLoaderFactory loaderFactory = new ClassLoaderFactory();
    private final Map<File, List<Item>> index = new TreeMap<File, List<Item>>();
    private final List<String> filesToRemove;

    public FileIndexer(File base, File patchedFilesFolder, Properties configuration, String ignore) {
        this.binaries = patchedFilesFolder;
        try {
            String path = patchedFilesFolder.getCanonicalFile().getAbsolutePath();
            this.binaryRoot = path + (path.endsWith(File.separator) ? "" : File.separator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        File libs = new File(base, "lib");
        if (!libs.isDirectory()) {
            throw new IllegalArgumentException("lib folder not found");
        }
        this.loader = this.loaderFactory.create(libs);
        String toRemove = configuration.getProperty("remove");
        this.filesToRemove = toRemove == null ? Collections.emptyList() : new ArrayList<String>(Arrays.asList(toRemove.split(" *, *")));
        this.ignore = ignore;
    }

    public Map<File, List<Item>> getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileIndexer index() {
        if (!this.index.isEmpty()) {
            return this;
        }
        try {
            this.doIndex(this.binaries);
            for (String toRemove : this.filesToRemove) {
                try {
                    this.addItem(null, Item.Action.REMOVE, toRemove);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                    return this;
                }
            }
        }
        finally {
            this.loaderFactory.release(this.loader);
        }
    }

    public FileIndexer dump(PrintStream out) {
        out.println("Index:");
        for (Map.Entry<File, List<Item>> items : this.index.entrySet()) {
            Collections.sort(items.getValue());
            out.println();
            out.println("  Location: " + items.getKey());
            for (Item i : items.getValue()) {
                out.println("    - " + i.getPath());
            }
        }
        return this;
    }

    private void doIndex(File binaries) {
        if (binaries.isFile()) {
            if (!this.ignore.equals(binaries.getName())) {
                this.doIndexLeaf(binaries);
            }
        } else {
            File[] children = binaries.listFiles();
            if (children == null) {
                return;
            }
            for (File file : children) {
                this.doIndex(file);
            }
        }
    }

    private void doIndexLeaf(File file) {
        try {
            String relative = file.getCanonicalFile().getAbsolutePath().substring(this.binaryRoot.length());
            String resource = relative.replace(File.separatorChar, '/');
            this.addItem(file, Item.Action.ADD_OR_UPDATE, resource);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void addItem(File file, Item.Action action, String resource) throws IOException {
        File jar = JarLocation.jarFromResource((ClassLoader)this.loader, (String)resource).getCanonicalFile();
        List<Item> list = this.index.get(jar);
        if (list == null) {
            list = new ArrayList<Item>();
            this.index.put(jar, list);
        }
        list.add(new Item(resource, file, action));
    }
}

