/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.maven.plugin.AbstractTomEEMojo;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildTomEEMojo
extends AbstractTomEEMojo {
    @Deprecated
    @Parameter(property="tomee-plugin.zip", defaultValue="true")
    protected boolean zip;
    @Parameter(property="tomee-plugin.attach", defaultValue="true")
    protected boolean attach;
    @Deprecated
    @Parameter(property="tomee-plugin.zip-file", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    protected File zipFile;
    @Parameter(property="tomee-plugin.output-base", defaultValue="${project.build.directory}/${project.build.finalName}")
    protected File base;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="tomee-plugin.classifier")
    protected String classifier = null;
    @Parameter(property="tomee-plugin.no-root", defaultValue="false")
    protected boolean skipArchiveRootFolder;
    @Parameter
    private Map<String, String> formats;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object prefix;
        super.execute();
        if (this.formats == null) {
            this.formats = Collections.emptyMap();
        }
        if (!((String)(prefix = this.catalinaBase.getParentFile().getAbsolutePath())).endsWith(File.separator)) {
            prefix = (String)prefix + File.separator;
        }
        if (this.skipArchiveRootFolder) {
            prefix = (String)prefix + this.catalinaBase.getName() + File.separator;
        }
        if (this.zip || this.formats.containsKey("zip")) {
            this.getLog().info((CharSequence)"Zipping Custom TomEE Distribution");
            String zip = this.formats.get("zip");
            File output = zip != null ? new File(zip) : this.zipFile;
            try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(output));){
                for (String entry : this.catalinaBase.list()) {
                    this.zip(zos, new File(this.catalinaBase, entry), (String)prefix);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            this.attach("zip", output);
        }
        if (this.formats != null) {
            this.formats.remove("zip");
            for (Map.Entry<String, String> format : this.formats.entrySet()) {
                String key = format.getKey();
                this.getLog().info((CharSequence)(key + "-ing Custom TomEE Distribution"));
                if ("tar.gz".equals(key)) {
                    String out = format.getValue();
                    File output = out != null ? new File(out) : new File(this.base.getParentFile(), this.base.getName() + "." + key);
                    Files.mkdirs((File)output.getParentFile());
                    try (TarArchiveOutputStream tarGz = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(output)));){
                        tarGz.setLongFileMode(2);
                        for (String entry : this.catalinaBase.list()) {
                            this.tarGz(tarGz, new File(this.catalinaBase, entry), (String)prefix);
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                    this.attach(key, output);
                    continue;
                }
                throw new MojoExecutionException(key + " format not supported");
            }
        }
    }

    private void attach(String ext, File output) {
        if (this.attach) {
            this.getLog().info((CharSequence)("Attaching Custom TomEE Distribution (" + ext + ")"));
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, ext, this.classifier, output);
            } else {
                this.projectHelper.attachArtifact(this.project, ext, output);
            }
        }
    }

    private void tarGz(TarArchiveOutputStream tarGz, File f, String prefix) throws IOException {
        String path = f.getPath().replace(prefix, "").replace(File.separator, "/");
        TarArchiveEntry archiveEntry = new TarArchiveEntry(f, path);
        if (this.isSh(path)) {
            archiveEntry.setMode(493);
        }
        tarGz.putArchiveEntry((ArchiveEntry)archiveEntry);
        if (f.isDirectory()) {
            tarGz.closeArchiveEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.tarGz(tarGz, child, prefix);
                }
            }
        } else {
            IO.copy((File)f, (OutputStream)tarGz);
            tarGz.closeArchiveEntry();
        }
    }

    private void zip(ZipArchiveOutputStream zip, File f, String prefix) throws IOException {
        String path = f.getPath().replace(prefix, "").replace(File.separator, "/");
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry(f, path);
        if (this.isSh(path)) {
            archiveEntry.setUnixMode(493);
        }
        zip.putArchiveEntry((ArchiveEntry)archiveEntry);
        if (f.isDirectory()) {
            zip.closeArchiveEntry();
            File[] files = f.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.zip(zip, child, prefix);
                }
            }
        } else {
            IO.copy((File)f, (OutputStream)zip);
            zip.closeArchiveEntry();
        }
    }

    private boolean isSh(String path) {
        return path.startsWith(this.catalinaBase.getName() + "/bin/") && path.endsWith(".sh");
    }

    @Override
    protected void run() {
    }

    @Override
    public String getCmd() {
        return null;
    }

    @Override
    protected boolean getWaitTomEE() {
        return false;
    }
}

