/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.openejb.maven.plugin.AbstractAddressMojo;
import org.apache.openejb.maven.plugin.TomEEException;

public abstract class AbstractCommandMojo
extends AbstractAddressMojo {
    @Parameter(property="tomee-plugin.ejbd-endpoint", defaultValue="/tomee/ejb")
    protected String ejbdEndpoint;
    @Parameter(property="tomee-plugin.command-force-https", defaultValue="false")
    protected boolean forceHttps;
    @Parameter
    protected Map<String, String> lookupVariables;

    protected Object lookup(String name) {
        if (this.tomeeHttpPort == null && this.tomeeHttpsPort == null) {
            this.tomeeHttpPort = "8080";
        }
        if (this.tomeeHost == null) {
            this.tomeeHost = "localhost";
        }
        if (this.ejbdEndpoint == null) {
            this.ejbdEndpoint = "/tomee/ejb";
        }
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", this.providerUrl());
        if (this.user != null) {
            props.put("java.naming.security.principal", this.user);
        }
        if (this.password != null) {
            props.put("java.naming.security.credentials", this.password);
        }
        if (this.realm != null) {
            props.put("openejb.authentication.realmName", this.realm);
        }
        if (this.lookupVariables != null) {
            props.putAll(this.lookupVariables);
        }
        try {
            return new InitialContext(props).lookup(name);
        }
        catch (Exception e) {
            throw new TomEEException("Not able to execute " + ((Object)((Object)this)).getClass().getSimpleName() + ", maybe add -Dopenejb.system.apps=true -Dtomee.remote.support=true to tomee", e);
        }
    }

    private String providerUrl() {
        if (this.forceHttps || this.tomeeHttpPort == null && this.tomeeHttpsPort != null) {
            return "https://" + this.tomeeHost + ":" + this.tomeeHttpsPort + this.ejbdEndpoint;
        }
        return "http://" + this.tomeeHost + ":" + this.tomeeHttpPort + this.ejbdEndpoint;
    }
}

