/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.embedded;

import jakarta.ejb.embeddable.EJBContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.openejb.maven.util.MavenLogStreamFactory;

@Mojo(name="run", defaultPhase=LifecyclePhase.COMPILE)
public class OpenEJBEmbeddedMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.artifactId}")
    private String id;
    @Parameter(property="embedded.provider", defaultValue="org.apache.openejb.OpenEjbContainer")
    private String provider;
    @Parameter(property="embedded.modules", defaultValue="${project.build.outputDirectory}")
    private String modules;
    @Parameter(property="embedded.await", defaultValue="true")
    private boolean await;
    @Parameter
    private Map<String, String> properties;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogStreamFactory.setLogger((Log)this.getLog());
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.createClassLoader(oldCl));
        EJBContainer container = null;
        try {
            container = EJBContainer.createEJBContainer(this.map());
            if (this.await) {
                final CountDownLatch latch = new CountDownLatch(1);
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                }));
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (container != null) {
                container.close();
            }
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private ClassLoader createClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("can't use artifact " + artifact.toString()));
            }
        }
        for (String str : this.modules.split(",")) {
            File file = new File(str);
            if (file.exists()) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("can't use path " + str));
                }
                continue;
            }
            this.getLog().warn((CharSequence)("can't find " + str));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    private Map<?, ?> map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jakarta.ejb.embeddable.appName", this.id);
        map.put("jakarta.ejb.embeddable.provider", this.provider);
        map.put("jakarta.ejb.embeddable.modules", this.modules.split(","));
        map.put("openejb.log.factory", "org.apache.openejb.maven.util.MavenLogStreamFactory");
        if (this.properties != null) {
            map.putAll(this.properties);
        }
        return map;
    }
}

