/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataContentHandlerFactory;
import jakarta.activation.DataSource;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import jakarta.activation.URLDataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;

public class DataHandler {
    private final DataSource ds;
    private final ActivationDataFlavor flavor;
    private CommandMap commandMap;
    private DataContentHandler dch;
    private DataContentHandlerFactory originalFactory;
    private static DataContentHandlerFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler(DataSource ds) {
        Class<DataHandler> clazz = DataHandler.class;
        synchronized (DataHandler.class) {
            this.originalFactory = factory;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.ds = ds;
            this.flavor = new ActivationDataFlavor(ds.getContentType(), null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler(Object data, String type) {
        Class<DataHandler> clazz = DataHandler.class;
        synchronized (DataHandler.class) {
            this.originalFactory = factory;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.ds = new ObjectDataSource(data, type);
            this.flavor = new ActivationDataFlavor((Class)data.getClass(), null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler(URL url) {
        Class<DataHandler> clazz = DataHandler.class;
        synchronized (DataHandler.class) {
            this.originalFactory = factory;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.ds = new URLDataSource(url);
            this.flavor = new ActivationDataFlavor(this.ds.getContentType(), null);
            return;
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public String getName() {
        return this.ds.getName();
    }

    public String getContentType() {
        return this.ds.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.ds.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException {
        if (this.ds instanceof ObjectDataSource) {
            ObjectDataSource ods = (ObjectDataSource)this.ds;
            DataContentHandler dch = this.getDataContentHandler();
            if (dch == null) {
                throw new UnsupportedDataTypeException(ods.mimeType);
            }
            dch.writeTo(ods.data, ods.mimeType, os);
        } else {
            byte[] buffer = new byte[1024];
            try (InputStream is = this.getInputStream();){
                int count;
                while ((count = is.read(buffer)) != -1) {
                    os.write(buffer, 0, count);
                }
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.ds.getOutputStream();
    }

    public synchronized ActivationDataFlavor[] getTransferDataFlavors() {
        return this.getDataContentHandler().getTransferDataFlavors();
    }

    public boolean isDataFlavorSupported(ActivationDataFlavor flavor) {
        ActivationDataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            ActivationDataFlavor dataFlavor = flavors[i];
            if (!dataFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(ActivationDataFlavor flavor) throws IOException {
        DataContentHandler dch = this.getDataContentHandler();
        if (dch != null) {
            return dch.getTransferData(flavor, this.ds);
        }
        if (this.flavor.equals(flavor)) {
            if (this.ds instanceof ObjectDataSource) {
                return ((ObjectDataSource)this.ds).data;
            }
            return this.ds.getInputStream();
        }
        throw new IOException("Unsupported DataFlavor: " + flavor);
    }

    public CommandInfo[] getPreferredCommands() {
        return this.getCommandMap().getPreferredCommands(this.ds.getContentType());
    }

    public CommandInfo[] getAllCommands() {
        return this.getCommandMap().getAllCommands(this.ds.getContentType());
    }

    public CommandInfo getCommand(String cmdName) {
        return this.getCommandMap().getCommand(this.ds.getContentType(), cmdName);
    }

    public Object getContent() throws IOException {
        if (this.ds instanceof ObjectDataSource) {
            return ((ObjectDataSource)this.ds).data;
        }
        DataContentHandler dch = this.getDataContentHandler();
        if (dch != null) {
            return dch.getContent(this.ds);
        }
        return this.ds.getInputStream();
    }

    public Object getBean(CommandInfo cmdinfo) {
        try {
            return cmdinfo.getCommandObject(this, this.getClass().getClassLoader());
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        this.commandMap = commandMap;
        this.dch = null;
    }

    private synchronized CommandMap getCommandMap() {
        return this.commandMap != null ? this.commandMap : CommandMap.getDefaultCommandMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DataContentHandler getDataContentHandler() {
        Class<DataHandler> clazz = DataHandler.class;
        synchronized (DataHandler.class) {
            if (factory != this.originalFactory) {
                this.dch = null;
                this.originalFactory = factory;
            }
            DataContentHandlerFactory localFactory = this.originalFactory;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.dch == null) {
                String mimeType = this.getMimeType(this.ds.getContentType());
                if (localFactory != null) {
                    this.dch = localFactory.createDataContentHandler(mimeType);
                }
                if (this.dch == null) {
                    this.dch = this.commandMap != null ? this.commandMap.createDataContentHandler(mimeType) : CommandMap.getDefaultCommandMap().createDataContentHandler(mimeType);
                }
            }
            return this.dch;
        }
    }

    private String getMimeType(String contentType) {
        try {
            MimeType mimeType = new MimeType(contentType);
            return mimeType.getBaseType();
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return contentType;
        }
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory newFactory) {
        if (factory != null) {
            throw new Error("jakarta.activation.DataHandler.setDataContentHandlerFactory has already been defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        factory = newFactory;
    }

    private class ObjectDataSource
    implements DataSource {
        private final Object data;
        private final String mimeType;

        public ObjectDataSource(Object data, String mimeType) {
            this.data = data;
            this.mimeType = mimeType;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getContentType() {
            return this.mimeType;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            final DataContentHandler dch = DataHandler.this.getDataContentHandler();
            if (dch == null) {
                throw new UnsupportedDataTypeException(this.mimeType);
            }
            PipedInputStream is = new PipedInputStream();
            final PipedOutputStream os = new PipedOutputStream(is);
            Thread thread = new Thread("DataHandler Pipe Pump"){

                @Override
                public void run() {
                    try {
                        try {
                            dch.writeTo(ObjectDataSource.this.data, ObjectDataSource.this.mimeType, os);
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            return is;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

