/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.itest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.tomee.server.composer.TomEE;
import org.junit.Assert;

public class Logging {
    private final List<String> output = new CopyOnWriteArrayList<String>();

    public void install(TomEE.Builder builder) {
        builder.watch("", "\n", this.output::add);
    }

    public Logging assertPresent(String regex) {
        ArrayList<String> output = new ArrayList<String>(this.output);
        Pattern pattern = Pattern.compile(regex);
        long count = output.stream().filter(line -> pattern.matcher((CharSequence)line).find()).count();
        Assert.assertTrue((count > 0L ? 1 : 0) != 0);
        return this;
    }

    public Logging assertPresent(int count, String regex) {
        ArrayList<String> output = new ArrayList<String>(this.output);
        Pattern pattern = Pattern.compile(regex);
        long actual = output.stream().filter(line -> pattern.matcher((CharSequence)line).find()).count();
        Assert.assertEquals((long)count, (long)actual);
        return this;
    }

    public Logging assertNotPresent(String s) {
        ArrayList<String> output = new ArrayList<String>(this.output);
        Optional<String> actual = output.stream().filter(line -> line.contains(s)).findFirst();
        Assert.assertTrue((boolean)actual.isEmpty());
        return this;
    }
}

