/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.gradle.embedded.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;

public class FilterGradleClassLoader
extends ClassLoader {
    private final ClassLoader delegate;

    public FilterGradleClassLoader(ClassLoader gradle) {
        super(gradle.getParent());
        this.delegate = gradle;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.checkClass(name);
        return this.delegate.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        if (!this.checkResource(name)) {
            return null;
        }
        return this.delegate.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = this.delegate.getResources(name);
        if (!this.checkResource(name)) {
            return Collections.emptyEnumeration();
        }
        return resources;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (!this.checkResource(name)) {
            return null;
        }
        return this.delegate.getResourceAsStream(name);
    }

    private void checkClass(String name) throws ClassNotFoundException {
        if (name != null && (name.startsWith("aQute") || name.startsWith("bsh") || name.startsWith("com.amazon") || name.startsWith("com.beust") || name.startsWith("com.esot") || name.startsWith("com.google") || name.startsWith("com.jackson") || name.startsWith("com.jcraft") || name.startsWith("com.tonixsystems") || name.startsWith("javax.el") || name.startsWith("javax.inject") || name.startsWith("javax.servlet") || name.startsWith("jcifs.") || name.startsWith("junit.") || name.startsWith("groovy") || name.startsWith("mozilla.") || name.startsWith("net.jcip.") || name.startsWith("net.ruby") || name.startsWith("org.apache.") || name.startsWith("org.bouncycastle.") || name.startsWith("org.codehaus.") || name.startsWith("org.cyber") || name.startsWith("org.dom4j.") || name.startsWith("org.eclipse.") || name.startsWith("org.fusesource.") || name.startsWith("org.hamcrest.") || name.startsWith("org.jaxen.") || name.startsWith("org.mortbay.") || name.startsWith("org.mozilla.") || name.startsWith("org.objectweb.") || name.startsWith("org.objenesis.") || name.startsWith("org.osgi.") || name.startsWith("org.simpleframework.") || name.startsWith("org.sonar.") || name.startsWith("org.sonatype.") || name.startsWith("org.testng.") || name.startsWith("org.yaml.") || this.isForbiddenGradleClass(name))) {
            throw new ClassNotFoundException();
        }
    }

    private boolean isForbiddenGradleClass(String name) {
        return name.startsWith("org.gradle.initialization") || name.startsWith("org.gradle.launcher") || name.startsWith("org.gradle.execution") || name.startsWith("org.gradle.internal") || name.startsWith("org.gradle.tooling") || name.startsWith("org.gradle.api.internal.tasks");
    }

    private boolean checkResource(String name) {
        return name != null && !name.startsWith("META-INF/services/com.fasterxml");
    }
}

