/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.gradle.embedded;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tomee.gradle.embedded.classloader.FilterGradleClassLoader;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GFileUtils;

public class TomEEEmbeddedTask
extends DefaultTask {
    @Optional
    @Input
    private int httpPort = 8080;
    @Optional
    @Input
    private int httpsPort = 8443;
    @Optional
    @Input
    private int ajpPort = 8009;
    @Optional
    @Input
    private int stopPort = 8005;
    @Optional
    @Input
    private String host = "localhost";
    @Optional
    @Input
    private String keystoreFile;
    @Optional
    @Input
    private String keystorePass;
    @Optional
    @Input
    private String keystoreType = "JKS";
    @Optional
    @Input
    private String clientAuth;
    @Optional
    @Input
    private String keyAlias;
    @Optional
    @Input
    private String sslProtocol;
    @Optional
    @Input
    private File serverXml;
    @Optional
    @Input
    private boolean singleClassloader = false;
    @Optional
    @Input
    private boolean ssl = false;
    @Optional
    @Input
    private boolean withEjbRemote = false;
    @Optional
    @Input
    private boolean quickSession = true;
    @Optional
    @Input
    private boolean skipHttp = false;
    @Optional
    @Input
    private Collection<String> applicationScopes = new HashSet<String>(Arrays.asList("compile", "runtime"));
    @Optional
    @Input
    private boolean webResourceCached = true;
    @Optional
    @Input
    private String context = null;
    @Optional
    @Input
    private Map<String, String> containerProperties;
    @Optional
    @Input
    private boolean keepServerXmlAsThis = false;
    @Optional
    @Input
    private Map<String, String> users;
    @Optional
    @Input
    private Map<String, String> roles;
    @Optional
    @Input
    private boolean forceJspDevelopment = true;
    @Optional
    @Input
    private String inlinedServerXml;
    @Optional
    @Input
    private String inlinedTomEEXml;
    @Optional
    @Input
    private File workDir;
    @Optional
    @Input
    private List<File> modules;
    @Optional
    @Input
    private File docBase;
    @Optional
    @Input
    private String dir;
    @Optional
    @Input
    private LogLevel logLevel = LogLevel.INFO;
    private Configuration classpath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void runTomEEEmbedded() {
        this.fixConfig();
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        LoggingManager logging = this.getProject().getLogging();
        LogSetup logSetup = new LogSetup(logging, logging.getStandardOutputCaptureLevel(), logging.getStandardErrorCaptureLevel(), this.logLevel).init();
        logging.setLevel(this.logLevel);
        thread.setContextClassLoader(this.createLoader(tccl));
        try {
            this.doRun();
        }
        finally {
            thread.setContextClassLoader(tccl);
            logSetup.reset();
        }
    }

    private void fixConfig() {
        File main;
        Project project = this.getProject();
        if (this.classpath == null) {
            this.classpath = project.getConfigurations().getByName("tomee-embedded");
        }
        if (this.docBase == null) {
            this.docBase = new File(project.getProjectDir(), "src/main/webapp");
        }
        if (this.workDir == null) {
            this.workDir = new File(project.getBuildDir(), "tomee-embedded/work");
        }
        if (this.dir == null) {
            this.dir = new File(project.getBuildDir(), "tomee-embedded/run").getAbsolutePath();
        }
        if ((this.modules == null || this.modules.isEmpty()) && (main = new File(project.getBuildDir(), "classes/main")).isDirectory()) {
            this.modules = new ArrayList<File>(Collections.singletonList(main));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        Thread hook;
        AutoCloseable container;
        Properties originalSystProp = new Properties();
        originalSystProp.putAll((Map<?, ?>)System.getProperties());
        Thread thread = Thread.currentThread();
        final ClassLoader loader = thread.getContextClassLoader();
        if (this.inlinedServerXml != null && !this.inlinedServerXml.trim().isEmpty()) {
            if (this.serverXml != null && this.serverXml.exists()) {
                throw new GradleException("you can't define a server.xml and an inlinedServerXml");
            }
            try {
                GFileUtils.mkdirs((File)this.workDir);
                this.serverXml = new File(this.workDir, "server.xml_dump");
                GFileUtils.writeFile((String)this.inlinedServerXml, (File)this.serverXml);
            }
            catch (Exception e) {
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
        final AtomicBoolean running = new AtomicBoolean();
        try {
            Class<?> containerClass = loader.loadClass("org.apache.tomee.embedded.Container");
            Class<?> configClass = loader.loadClass("org.apache.tomee.embedded.Configuration");
            Class<?> parentLoaderFinderClass = loader.loadClass("org.apache.openejb.core.ParentClassLoaderFinder");
            Class<?> loaderFinderClass = loader.loadClass("org.apache.openejb.core.ProvidedClassLoaderFinder");
            Class<?> systemInstanceClass = loader.loadClass("org.apache.openejb.loader.SystemInstance");
            container = (AutoCloseable)AutoCloseable.class.cast(containerClass.newInstance());
            Object config = this.getConfig(configClass);
            containerClass.getMethod("setup", configClass).invoke((Object)container, config);
            if (this.inlinedTomEEXml != null && this.inlinedTomEEXml.trim().isEmpty()) {
                try {
                    File conf = new File(this.dir, "conf");
                    GFileUtils.mkdirs((File)conf);
                    GFileUtils.writeFile((String)this.inlinedTomEEXml, (File)new File(conf, "tomee.xml"));
                }
                catch (Exception e) {
                    throw new GradleException(e.getMessage(), (Throwable)e);
                }
            }
            final AutoCloseable finalContainer = container;
            hook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (running.compareAndSet(true, false)) {
                        Thread thread = Thread.currentThread();
                        ClassLoader old = thread.getContextClassLoader();
                        thread.setContextClassLoader(loader);
                        try {
                            finalContainer.close();
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            TomEEEmbeddedTask.this.getLogger().debug("can't stop TomEE", (Throwable)noClassDefFoundError);
                        }
                        catch (Exception e) {
                            TomEEEmbeddedTask.this.getLogger().error("can't stop TomEE", (Throwable)e);
                        }
                        finally {
                            thread.setContextClassLoader(old);
                        }
                    }
                }
            };
            hook.setName("TomEE-Embedded-ShutdownHook");
            running.set(true);
            containerClass.getMethod("start", new Class[0]).invoke((Object)container, new Object[0]);
            Object providedLoaderFinder = loaderFinderClass.getConstructor(ClassLoader.class).newInstance(loader);
            Object systemInstance = systemInstanceClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            systemInstanceClass.getMethod("setComponent", Class.class, Object.class).invoke(systemInstance, parentLoaderFinderClass, providedLoaderFinder);
            Runtime.getRuntime().addShutdownHook(hook);
            containerClass.getMethod("deployClasspathAsWebApp", String.class, File.class, Boolean.TYPE).invoke((Object)container, this.context, this.docBase, this.singleClassloader);
            this.getLogger().info("TomEE embedded started on " + configClass.getMethod("getHost", new Class[0]).invoke(config, new Object[0]) + ":" + configClass.getMethod("getHttpPort", new Class[0]).invoke(config, new Object[0]));
        }
        catch (Exception e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
        try {
            String line;
            Scanner scanner = new Scanner(System.in);
            while ((line = scanner.nextLine()) != null) {
                switch (line.trim()) {
                    case "exit": 
                    case "quit": {
                        running.set(false);
                        Runtime.getRuntime().removeShutdownHook(hook);
                        container.close();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            Thread.interrupted();
        }
        finally {
            thread.setContextClassLoader(loader);
            System.setProperties(originalSystProp);
        }
    }

    private Object getConfig(Class<?> configClass) throws Exception {
        Object config = configClass.newInstance();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                Field configField = Configuration.class.getDeclaredField(field.getName());
                field.setAccessible(true);
                configField.setAccessible(true);
                Object value = field.get((Object)this);
                if (value == null) continue;
                configField.set(config, value);
                this.getLogger().debug("using " + field.getName() + " = " + value);
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (Exception e) {
                this.getLogger().warn("can't initialize attribute " + field.getName());
            }
        }
        if (this.containerProperties == null) {
            this.containerProperties = new HashMap<String, String>();
        }
        if (this.forceJspDevelopment) {
            this.containerProperties.put("tomee.jsp-development", "true");
        }
        this.containerProperties.put("openejb.log.factory", "slf4j");
        String original = this.containerProperties.get("openejb.additional.exclude");
        String additional = "gradle,ant,jna,native-platform,reflectasm,bsh,jetty,rhino,aws,core-3,bcpg,jsch,pmaven,sonar,bndlib,jatl,simple-,snakeyaml,jcl-over-slf4j,ivy,jarjar,jul-to-slf4j,jaxen,minlog,jcip-annotations,kryo,objenesis";
        if (original == null) {
            this.containerProperties.put("openejb.additional.exclude", "gradle,ant,jna,native-platform,reflectasm,bsh,jetty,rhino,aws,core-3,bcpg,jsch,pmaven,sonar,bndlib,jatl,simple-,snakeyaml,jcl-over-slf4j,ivy,jarjar,jul-to-slf4j,jaxen,minlog,jcip-annotations,kryo,objenesis");
        } else {
            this.containerProperties.put("openejb.additional.exclude", original + ',' + "gradle,ant,jna,native-platform,reflectasm,bsh,jetty,rhino,aws,core-3,bcpg,jsch,pmaven,sonar,bndlib,jatl,simple-,snakeyaml,jcl-over-slf4j,ivy,jarjar,jul-to-slf4j,jaxen,minlog,jcip-annotations,kryo,objenesis");
        }
        if (this.containerProperties != null) {
            Properties props = new Properties();
            props.putAll(this.containerProperties);
            configClass.getMethod("setProperties", Properties.class).invoke(config, props);
        }
        return config;
    }

    private ClassLoader createLoader(ClassLoader parent) {
        this.getLogger().info("Resolving tomee-embedded classpath...");
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>(64);
        this.addFiles(this.modules, urls);
        for (Configuration cc : this.getProject().getConfigurations()) {
            if (!this.applicationScopes.contains(cc.getName())) continue;
            this.addFiles(cc.getFiles(), urls);
        }
        this.addFiles(this.classpath.getFiles(), urls);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)new FilterGradleClassLoader(parent));
    }

    private void addFiles(Collection<File> files, Collection<URL> urls) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (File f : files) {
            String name = f.getName();
            if (name.startsWith("slf4j-api") || name.startsWith("slf4j-jdk14")) continue;
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public File getServerXml() {
        return this.serverXml;
    }

    public void setServerXml(File serverXml) {
        this.serverXml = serverXml;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isWithEjbRemote() {
        return this.withEjbRemote;
    }

    public void setWithEjbRemote(boolean withEjbRemote) {
        this.withEjbRemote = withEjbRemote;
    }

    public boolean isQuickSession() {
        return this.quickSession;
    }

    public void setQuickSession(boolean quickSession) {
        this.quickSession = quickSession;
    }

    public boolean isSkipHttp() {
        return this.skipHttp;
    }

    public void setSkipHttp(boolean skipHttp) {
        this.skipHttp = skipHttp;
    }

    public Collection<String> getApplicationScopes() {
        return this.applicationScopes;
    }

    public void setApplicationScopes(Collection<String> applicationScopes) {
        this.applicationScopes = applicationScopes;
    }

    public boolean isWebResourceCached() {
        return this.webResourceCached;
    }

    public void setWebResourceCached(boolean webResourceCached) {
        this.webResourceCached = webResourceCached;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Map<String, String> getContainerProperties() {
        return this.containerProperties;
    }

    public void setContainerProperties(Map<String, String> containerProperties) {
        this.containerProperties = containerProperties;
    }

    public boolean isKeepServerXmlAsThis() {
        return this.keepServerXmlAsThis;
    }

    public void setKeepServerXmlAsThis(boolean keepServerXmlAsThis) {
        this.keepServerXmlAsThis = keepServerXmlAsThis;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public boolean isForceJspDevelopment() {
        return this.forceJspDevelopment;
    }

    public void setForceJspDevelopment(boolean forceJspDevelopment) {
        this.forceJspDevelopment = forceJspDevelopment;
    }

    public String getInlinedServerXml() {
        return this.inlinedServerXml;
    }

    public void setInlinedServerXml(String inlinedServerXml) {
        this.inlinedServerXml = inlinedServerXml;
    }

    public String getInlinedTomEEXml() {
        return this.inlinedTomEEXml;
    }

    public void setInlinedTomEEXml(String inlinedTomEEXml) {
        this.inlinedTomEEXml = inlinedTomEEXml;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public List<File> getModules() {
        return this.modules;
    }

    public void setModules(List<File> modules) {
        this.modules = modules;
    }

    public File getDocBase() {
        return this.docBase;
    }

    public void setDocBase(File docBase) {
        this.docBase = docBase;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public Configuration getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Configuration classpath) {
        this.classpath = classpath;
    }

    private static final class LogSetup {
        private final LoggingManager logging;
        private final LogLevel stdOutLvl;
        private final LogLevel stdErrLvl;
        private final LogLevel requiredLvl;

        private LogSetup(LoggingManager logging, LogLevel stdOutLvl, LogLevel stdErrLvl, LogLevel requiredLvl) {
            this.logging = logging;
            this.stdOutLvl = stdOutLvl;
            this.stdErrLvl = stdErrLvl;
            this.requiredLvl = requiredLvl;
        }

        public LogSetup init() {
            this.logging.captureStandardError(this.requiredLvl);
            this.logging.captureStandardOutput(this.requiredLvl);
            return this;
        }

        public void reset() {
            this.logging.captureStandardError(this.stdErrLvl);
            this.logging.captureStandardOutput(this.stdOutLvl);
        }
    }
}

