/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.embedded;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Prefixes;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.jboss.arquillian.config.descriptor.api.Multiline;

@Prefixes(value={"tomee", "tomee.embedded"})
public class EmbeddedTomEEConfiguration
extends TomEEConfiguration {
    private int httpsPort = 8443;
    private boolean ssl;
    private boolean withEjbRemote;
    private String keystoreFile;
    private String keystorePass;
    private String keystoreType = "JKS";
    private String clientAuth;
    private String keyAlias;
    private String sslProtocol;
    private String users;
    private String roles;
    private boolean webResourcesCached = true;
    private boolean http2;
    private String configurationCustomizers;
    private String classpathConfiguration;

    public EmbeddedTomEEConfiguration() {
        this.setArquillianProtocol("Local");
    }

    public String getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    public void setClasspathConfiguration(String classpathConfiguration) {
        this.classpathConfiguration = classpathConfiguration;
    }

    public boolean isHttp2() {
        return this.http2;
    }

    public void setHttp2(boolean http2) {
        this.http2 = http2;
    }

    public void setConfigurationCustomizers(String configurationCustomizers) {
        this.configurationCustomizers = configurationCustomizers;
    }

    public String getConfigurationCustomizers() {
        return this.configurationCustomizers;
    }

    public boolean isWebResourcesCached() {
        return this.webResourcesCached;
    }

    public void setWebResourcesCached(boolean webResourcesCached) {
        this.webResourcesCached = webResourcesCached;
    }

    public boolean isWithEjbRemote() {
        return this.withEjbRemote;
    }

    public void setWithEjbRemote(boolean withEjbRemote) {
        this.withEjbRemote = withEjbRemote;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getUsers() {
        return this.users;
    }

    public Properties getUsersAsProperties() {
        return EmbeddedTomEEConfiguration.toProperties(this.users);
    }

    @Multiline
    public void setUsers(String users) {
        this.users = users;
    }

    public String getRoles() {
        return this.roles;
    }

    public Properties getRolesAsProperties() {
        return EmbeddedTomEEConfiguration.toProperties(this.roles);
    }

    @Multiline
    public void setRoles(String roles) {
        this.roles = roles;
    }

    public int[] portsAlreadySet() {
        ArrayList<Integer> value = new ArrayList<Integer>();
        if (this.getStopPort() > 0) {
            value.add(this.getStopPort());
        }
        if (this.getHttpPort() > 0) {
            value.add(this.getHttpPort());
        }
        if (this.getHttpsPort() > 0) {
            value.add(this.getHttpsPort());
        }
        return this.toInts(value);
    }

    public Properties systemPropertiesAsProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return new Properties();
        }
        Properties properties = EmbeddedTomEEConfiguration.toProperties(this.properties);
        if (properties != null && this.isUnsafeEjbd() && "*".equals(properties.getProperty("tomee.serialization.class.blacklist", "-").trim())) {
            properties.remove("tomee.serialization.class.blacklist");
            properties.put("tomee.serialization.class.whitelist", "*");
            System.setProperty("tomee.serialization.class.blacklist", System.getProperty("tomee.serialization.class.blacklist", "-"));
        }
        return properties;
    }

    private static Properties toProperties(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(value.getBytes());
        try {
            properties.load(bais);
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
        finally {
            try {
                IO.close((Closeable)bais);
            }
            catch (IOException iOException) {}
        }
        return properties;
    }
}

