/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Map;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;

public class CorbaObjectReader
extends ObjectReader {
    final InputStream in;
    final Map offsetMap;

    CorbaObjectReader(org.omg.CORBA.portable.InputStream in, Map offsetMap, Serializable obj) throws IOException {
        super(obj);
        this.in = (InputStream)in;
        this.offsetMap = offsetMap;
    }

    public void readFully(byte[] arr, int off, int val) throws IOException {
        this.in.read_octet_array(arr, off, val);
    }

    public int skipBytes(int len) throws IOException {
        byte[] data = new byte[len];
        this.readFully(data, 0, len);
        return len;
    }

    public boolean readBoolean() throws IOException {
        return this.in.read_boolean();
    }

    public byte readByte() throws IOException {
        return this.in.read_octet();
    }

    public int readUnsignedByte() throws IOException {
        byte val = this.in.read_octet();
        return val & 0xFF;
    }

    public short readShort() throws IOException {
        return this.in.read_short();
    }

    public int readUnsignedShort() throws IOException {
        short val = this.in.read_short();
        return val & 0xFFFF;
    }

    public char readChar() throws IOException {
        return this.in.read_wchar();
    }

    public int readInt() throws IOException {
        return this.in.read_long();
    }

    public long readLong() throws IOException {
        return this.in.read_longlong();
    }

    public float readFloat() throws IOException {
        return this.in.read_float();
    }

    public double readDouble() throws IOException {
        return this.in.read_double();
    }

    public String readLine() throws IOException {
        char ch;
        StringBuffer buf = new StringBuffer();
        try {
            ch = (char)this.readUnsignedByte();
        }
        catch (MARSHAL ex) {
            return null;
        }
        while (true) {
            char ch2;
            buf.append(ch);
            try {
                ch = (char)this.readUnsignedByte();
            }
            catch (MARSHAL ex) {
                return buf.toString();
            }
            if (ch == '\n') {
                return buf.toString();
            }
            if (ch != '\r') continue;
            try {
                ch2 = (char)this.readUnsignedByte();
            }
            catch (MARSHAL ex) {
                return buf.toString();
            }
            if (ch2 == '\n') {
                return buf.toString();
            }
            ch = ch2;
        }
    }

    public String readUTF() throws IOException {
        return this.in.read_wstring();
    }

    public java.lang.Object readAbstractObject() throws IndirectionException {
        try {
            return this.in.read_abstract_interface();
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(new Integer(ex.offset));
        }
    }

    public java.lang.Object readAny() throws IndirectionException {
        try {
            return Util.readAny((org.omg.CORBA.portable.InputStream)this.in);
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(new Integer(ex.offset));
        }
    }

    public java.lang.Object readValueObject() throws IndirectionException {
        try {
            return this.in.read_value();
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(new Integer(ex.offset));
        }
    }

    public java.lang.Object readValueObject(Class clz) throws IndirectionException {
        try {
            return this.in.read_value(clz);
        }
        catch (IndirectionException ex) {
            return this.offsetMap.get(new Integer(ex.offset));
        }
    }

    public Object readCorbaObject(Class type) {
        Object objref = this.in.read_Object();
        return objref;
    }

    public Remote readRemoteObject(Class type) {
        Object objref = this.in.read_Object();
        return (Remote)PortableRemoteObject.narrow((java.lang.Object)objref, (Class)type);
    }

    public int read() throws IOException {
        return this.readUnsignedByte();
    }

    public int read(byte[] arr) throws IOException {
        return this.read(arr, 0, arr.length);
    }

    public int read(byte[] arr, int off, int len) throws IOException {
        this.readFully(arr, off, len);
        return len;
    }

    public long skip(long len) throws IOException {
        this.skipBytes((int)len);
        return len;
    }

    public int available() throws IOException {
        return this.in.available();
    }
}

