/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import jakarta.enterprise.context.RequestScoped;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

public class EEFilter
implements Filter {
    private SecurityService securityService;
    private boolean active;

    public void init(FilterConfig filterConfig) throws ServletException {
        SystemInstance si = SystemInstance.isInitialized() ? SystemInstance.get() : null;
        Properties config = si != null ? si.getProperties() : System.getProperties();
        this.securityService = si != null ? (SecurityService)si.getComponent(SecurityService.class) : null;
        this.active = Boolean.parseBoolean(config.getProperty("tomee.http.request.wrap", "true"));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        WebBeansContext ctx;
        boolean shouldWrap;
        boolean bl = shouldWrap = this.active && HttpServletRequest.class.isInstance(servletRequest);
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            filterChain.doFilter((ServletRequest)(shouldWrap ? new NoCdiRequest((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), servletResponse, this) : servletRequest), servletResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)(servletRequest.isAsyncSupported() && (ctx = WebBeansContext.currentInstance()) != null ? new CdiRequest((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), servletResponse, ctx, this) : (shouldWrap ? new NoCdiRequest((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), servletResponse, this) : servletRequest)), servletResponse);
    }

    private void onLogout(HttpServletRequest request) {
        this.securityService.onLogout(request);
    }

    public void destroy() {
    }

    public static class AsynContextWrapper
    implements AsyncContext {
        private final AsyncContext delegate;
        private final CdiAppContextsService service;
        private final ServletResponse response;
        private volatile ServletRequest request;
        private volatile ServletRequestEvent event;

        public AsynContextWrapper(AsyncContext asyncContext, ServletRequest request, ServletResponse response, WebBeansContext webBeansContext) {
            this.delegate = asyncContext;
            this.service = (CdiAppContextsService)CdiAppContextsService.class.cast(webBeansContext.getService(ContextsService.class));
            this.event = null;
            this.request = request;
            this.response = response;
        }

        private boolean startRequestScope() {
            if (this.service.getRequestContext(false) == null) {
                this.service.startContext(RequestScoped.class, (Object)this.getEvent());
                return true;
            }
            return false;
        }

        private void stopRequestScope() {
            this.service.endContext(RequestScoped.class, (Object)this.getEvent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServletRequestEvent getEvent() {
            if (this.event != null) {
                return this.event;
            }
            if (this.request == null) {
                return null;
            }
            ServletRequest request = this.getRequest();
            if (this.event == null || this.event.getServletRequest() != request) {
                AsynContextWrapper asynContextWrapper = this;
                synchronized (asynContextWrapper) {
                    if (this.event == null || this.event.getServletRequest() != request) {
                        this.event = new ServletRequestEvent(request.getServletContext(), request);
                    }
                }
            }
            return this.event;
        }

        public ServletRequest getRequest() {
            if (this.request != null) {
                return this.request;
            }
            return this.delegate.getRequest();
        }

        public ServletResponse getResponse() {
            return this.delegate.getResponse();
        }

        public boolean hasOriginalRequestAndResponse() {
            boolean tomcatHasOriginalRequestAndResponse = this.delegate.hasOriginalRequestAndResponse();
            if (!tomcatHasOriginalRequestAndResponse && this.request instanceof NoCdiRequest) {
                NoCdiRequest noCdiRequest = (NoCdiRequest)this.request;
                return noCdiRequest == this.delegate.getRequest() && noCdiRequest.getResponse() == this.delegate.getResponse();
            }
            return tomcatHasOriginalRequestAndResponse;
        }

        public void dispatch() {
            try {
                this.delegate.dispatch();
            }
            finally {
                this.request = null;
            }
        }

        public void dispatch(String s) {
            try {
                this.delegate.dispatch(s);
            }
            finally {
                this.request = null;
            }
        }

        public void dispatch(ServletContext servletContext, String s) {
            try {
                this.delegate.dispatch(servletContext, s);
            }
            finally {
                this.request = null;
            }
        }

        public void complete() {
            boolean created = this.startRequestScope();
            try {
                this.delegate.complete();
            }
            finally {
                if (created) {
                    this.stopRequestScope();
                }
            }
        }

        public void start(final Runnable runnable) {
            this.delegate.start(new Runnable(){

                @Override
                public void run() {
                    this.startRequestScope();
                    try {
                        runnable.run();
                    }
                    finally {
                        this.stopRequestScope();
                    }
                }
            });
        }

        public void addListener(AsyncListener asyncListener) {
            this.delegate.addListener(this.wrapListener(asyncListener));
        }

        private AsyncListener wrapListener(AsyncListener asyncListener) {
            return new ScopeAwareListener(asyncListener);
        }

        public void addListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.delegate.addListener(this.wrapListener(asyncListener), servletRequest, servletResponse);
        }

        public <T extends AsyncListener> T createListener(Class<T> aClass) throws ServletException {
            return (T)this.delegate.createListener(aClass);
        }

        public void setTimeout(long l) {
            this.delegate.setTimeout(l);
        }

        public long getTimeout() {
            return this.delegate.getTimeout();
        }

        private class ScopeAwareListener
        implements AsyncListener {
            private final AsyncListener delegate;

            public ScopeAwareListener(AsyncListener asyncListener) {
                this.delegate = asyncListener;
            }

            public void onComplete(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onComplete(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onTimeout(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onError(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onError(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onStartAsync(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }
        }
    }

    public static class CdiRequest
    extends NoCdiRequest {
        private final WebBeansContext webBeansContext;
        private final AtomicReference<AsynContextWrapper> asyncContextWrapperReference = new AtomicReference();

        public CdiRequest(HttpServletRequest cast, ServletResponse response, WebBeansContext webBeansContext, EEFilter filter) {
            super(cast, response, filter);
            this.webBeansContext = webBeansContext;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            this.asyncContextWrapperReference.compareAndSet(null, new AsynContextWrapper(super.startAsync(), (ServletRequest)this, this.getResponse(), this.webBeansContext));
            return this.asyncContextWrapperReference.get();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            this.asyncContextWrapperReference.compareAndSet(null, new AsynContextWrapper(super.startAsync(servletRequest, servletResponse), servletRequest, servletResponse, this.webBeansContext));
            return this.asyncContextWrapperReference.get();
        }

        public AsyncContext getAsyncContext() {
            return this.asyncContextWrapperReference.get();
        }
    }

    public static class NoCdiRequest
    extends HttpServletRequestWrapper {
        private final ServletResponse response;
        private final EEFilter filter;

        public NoCdiRequest(HttpServletRequest cast, ServletResponse response, EEFilter filter) {
            super(cast);
            this.response = response;
            this.filter = filter;
        }

        public void logout() throws ServletException {
            try {
                super.logout();
            }
            finally {
                this.filter.onLogout((HttpServletRequest)HttpServletRequest.class.cast(this.getRequest()));
            }
        }

        public int hashCode() {
            return this.getRequest().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NoCdiRequest) {
                return this.getRequest().equals(((NoCdiRequest)((Object)obj)).getRequest());
            }
            return this.getRequest().equals(obj);
        }

        protected ServletResponse getResponse() {
            return this.response;
        }
    }
}

