/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class OAuthJoseJwtConsumer
extends JoseJwtConsumer {
    private boolean decryptWithClientSecret;
    private boolean verifyWithClientSecret;

    public JwtToken getJwtToken(String wrappedJwtToken, String clientSecret) {
        return this.getJwtToken(wrappedJwtToken, this.getInitializedDecryptionProvider(clientSecret), this.getInitializedSignatureVerifier(clientSecret));
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(String clientSecret) {
        if (this.verifyWithClientSecret && !StringUtils.isEmpty(clientSecret)) {
            return OAuthUtils.getClientSecretSignatureVerifier(clientSecret);
        }
        return null;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(String clientSecret) {
        if (this.decryptWithClientSecret && !StringUtils.isEmpty(clientSecret)) {
            return OAuthUtils.getClientSecretDecryptionProvider(clientSecret);
        }
        return null;
    }

    public boolean isDecryptWithClientSecret() {
        return this.decryptWithClientSecret;
    }

    public void setDecryptWithClientSecret(boolean decryptWithClientSecret) {
        this.decryptWithClientSecret = decryptWithClientSecret;
    }

    public boolean isVerifyWithClientSecret() {
        return this.verifyWithClientSecret;
    }

    public void setVerifyWithClientSecret(boolean verifyWithClientSecret) {
        this.verifyWithClientSecret = verifyWithClientSecret;
    }
}

