/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.grants.code.PlainCodeVerifier;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class AuthorizationCodeGrantHandler
extends AbstractGrantHandler {
    private List<CodeVerifierTransformer> codeVerifierTransformers = Collections.emptyList();
    private boolean expectCodeVerifierForPublicClients;
    private boolean requireCodeVerifier;

    public AuthorizationCodeGrantHandler() {
        super("authorization_code");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String clientCodeChallengeMethod;
        String clientCodeChallenge;
        String codeValue = (String)params.getFirst((Object)"code");
        ServerAuthorizationCodeGrant grant = ((AuthorizationCodeDataProvider)this.getDataProvider()).removeCodeGrant(codeValue);
        if (grant == null) {
            return null;
        }
        if (OAuthUtils.isExpired(grant.getIssuedAt(), grant.getExpiresIn())) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (!grant.getClient().getClientId().equals(client.getClientId())) {
            throw new OAuthServiceException("invalid_grant");
        }
        String expectedRedirectUri = grant.getRedirectUri();
        String providedRedirectUri = (String)params.getFirst((Object)"redirect_uri");
        if (providedRedirectUri != null ? !providedRedirectUri.equals(expectedRedirectUri) : expectedRedirectUri == null && !this.isCanSupportPublicClients() || expectedRedirectUri != null && (client.getRedirectUris().size() != 1 || !client.getRedirectUris().contains(expectedRedirectUri))) {
            throw new OAuthServiceException("invalid_request");
        }
        String clientCodeVerifier = (String)params.getFirst((Object)"code_verifier");
        if (!this.compareCodeVerifierWithChallenge(client, clientCodeVerifier, clientCodeChallenge = grant.getClientCodeChallenge(), clientCodeChallengeMethod = grant.getClientCodeChallengeMethod())) {
            throw new OAuthServiceException("invalid_grant");
        }
        List<String> audiences = this.getAudiences(client, params, grant.getAudience());
        return this.doCreateAccessToken(client, grant, this.getSingleGrantType(), clientCodeVerifier, audiences);
    }

    protected List<String> getAudiences(Client client, MultivaluedMap<String, String> params, String grantAudience) {
        String clientAudience = (String)params.getFirst((Object)"audience");
        if (client.getRegisteredAudiences().isEmpty() && clientAudience == null && grantAudience == null) {
            return Collections.emptyList();
        }
        if (grantAudience != null && clientAudience != null && !grantAudience.equals(clientAudience)) {
            throw new OAuthServiceException("invalid_request");
        }
        return this.getAudiences(client, clientAudience == null ? grantAudience : clientAudience);
    }

    private ServerAccessToken doCreateAccessToken(Client client, ServerAuthorizationCodeGrant grant, String requestedGrant, String codeVerifier, List<String> audiences) {
        if (grant.isPreauthorizedTokenAvailable()) {
            ServerAccessToken token = this.getPreAuthorizedToken(client, grant.getSubject(), requestedGrant, grant.getRequestedScopes(), this.getAudiences(client, grant.getAudience()));
            if (token != null) {
                if (grant.getNonce() != null) {
                    JAXRSUtils.getCurrentMessage().getExchange().put("nonce", grant.getNonce());
                }
                return token;
            }
            throw new OAuthServiceException("invalid_grant");
        }
        if (!client.getAllowedGrantTypes().isEmpty() && !client.getAllowedGrantTypes().contains(requestedGrant)) {
            throw new OAuthServiceException("invalid_grant");
        }
        AccessTokenRegistration reg = new AccessTokenRegistration();
        reg.setGrantCode(grant.getCode());
        reg.setClient(client);
        reg.setGrantType(requestedGrant);
        reg.setSubject(grant.getSubject());
        reg.setRequestedScope(grant.getRequestedScopes());
        reg.setNonce(grant.getNonce());
        if (grant.getApprovedScopes() != null) {
            reg.setApprovedScope(grant.getApprovedScopes());
        } else {
            reg.setApprovedScope(Collections.emptyList());
        }
        reg.setAudiences(audiences);
        reg.setResponseType(grant.getResponseType());
        reg.setClientCodeVerifier(codeVerifier);
        reg.getExtraProperties().putAll(grant.getExtraProperties());
        return this.getDataProvider().createAccessToken(reg);
    }

    private boolean compareCodeVerifierWithChallenge(Client c, String clientCodeVerifier, String clientCodeChallenge, String clientCodeChallengeMethod) {
        if (clientCodeChallenge == null && clientCodeVerifier == null) {
            if (this.requireCodeVerifier) {
                return false;
            }
            return c.isConfidential() || !this.expectCodeVerifierForPublicClients;
        }
        if (clientCodeChallenge != null && clientCodeVerifier == null || clientCodeChallenge == null && clientCodeVerifier != null) {
            return false;
        }
        CodeVerifierTransformer codeVerifierTransformer = null;
        if (!this.codeVerifierTransformers.isEmpty() && clientCodeChallengeMethod != null && (codeVerifierTransformer = (CodeVerifierTransformer)this.codeVerifierTransformers.stream().filter(t -> clientCodeChallengeMethod.equals(t.getChallengeMethod())).findAny().orElse(null)) == null) {
            return false;
        }
        if (codeVerifierTransformer == null) {
            codeVerifierTransformer = new PlainCodeVerifier();
        }
        String transformedCodeVerifier = codeVerifierTransformer.transformCodeVerifier(clientCodeVerifier);
        return clientCodeChallenge.equals(transformedCodeVerifier);
    }

    public void setCodeVerifierTransformer(CodeVerifierTransformer codeVerifier) {
        this.setCodeVerifierTransformers(codeVerifier == null ? null : Collections.singletonList(codeVerifier));
    }

    public void setCodeVerifierTransformers(List<CodeVerifierTransformer> codeVerifierTransformers) {
        if (codeVerifierTransformers == null) {
            this.codeVerifierTransformers = Collections.emptyList();
        }
        this.codeVerifierTransformers = new ArrayList<CodeVerifierTransformer>(codeVerifierTransformers);
    }

    public void setExpectCodeVerifierForPublicClients(boolean expectCodeVerifierForPublicClients) {
        this.expectCodeVerifierForPublicClients = expectCodeVerifierForPublicClients;
    }

    public void setRequireCodeVerifier(boolean requireCodeVerifier) {
        this.requireCodeVerifier = requireCodeVerifier;
    }
}

