/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.JweException;

public class JweOutputStream
extends FilterOutputStream {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweOutputStream.class);
    private final Cipher encryptingCipher;
    private final int blockSize;
    private final AuthenticationTagProducer authTagProducer;
    private byte[] lastRawDataChunk;
    private byte[] lastEncryptedDataChunk;
    private boolean flushed;

    public JweOutputStream(OutputStream out, Cipher encryptingCipher, AuthenticationTagProducer authTagProducer) {
        super(out);
        this.encryptingCipher = encryptingCipher;
        this.blockSize = encryptingCipher.getBlockSize();
        this.authTagProducer = authTagProducer;
    }

    @Override
    public void write(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int chunkSize;
        if (this.lastRawDataChunk != null) {
            int remaining = this.blockSize - this.lastRawDataChunk.length;
            int lenToCopy = remaining < len ? remaining : len;
            this.lastRawDataChunk = this.newArray(this.lastRawDataChunk, 0, this.lastRawDataChunk.length, b, off, lenToCopy);
            off += lenToCopy;
            len -= lenToCopy;
            if (this.lastRawDataChunk.length < this.blockSize) {
                return;
            }
            this.encryptAndWrite(this.lastRawDataChunk, 0, this.lastRawDataChunk.length);
            this.lastRawDataChunk = null;
        }
        int offset = 0;
        int n = chunkSize = this.blockSize > len ? this.blockSize : this.blockSize * (len / this.blockSize);
        while (offset + chunkSize <= len) {
            this.encryptAndWrite(b, off, chunkSize);
            offset += chunkSize;
            off += chunkSize;
        }
        if (offset < len) {
            this.lastRawDataChunk = this.newArray(b, off, len - offset);
        }
    }

    private void encryptAndWrite(byte[] chunk, int off, int len) throws IOException {
        byte[] encrypted = this.encryptingCipher.update(chunk, off, len);
        if (encrypted != null) {
            if (this.authTagProducer != null) {
                this.authTagProducer.update(encrypted, 0, encrypted.length);
            }
            this.encodeAndWrite(encrypted, 0, encrypted.length, false);
        }
    }

    private void encodeAndWrite(byte[] encryptedChunk, int off, int len, boolean finalWrite) throws IOException {
        byte[] theChunk = this.lastEncryptedDataChunk;
        int lenToEncode = len;
        if (theChunk != null) {
            theChunk = this.newArray(theChunk, 0, theChunk.length, encryptedChunk, off, len);
            lenToEncode = theChunk.length;
            off = 0;
        } else {
            theChunk = encryptedChunk;
        }
        int rem = finalWrite ? 0 : lenToEncode % 3;
        Base64UrlUtility.encodeAndStream(theChunk, off, lenToEncode - rem, this.out);
        this.out.flush();
        this.lastEncryptedDataChunk = (byte[])(rem > 0 ? this.newArray(theChunk, lenToEncode - rem, rem) : null);
    }

    public void finalFlush() throws IOException {
        if (this.flushed) {
            return;
        }
        try {
            byte[] finalBytes = this.lastRawDataChunk == null ? this.encryptingCipher.doFinal() : this.encryptingCipher.doFinal(this.lastRawDataChunk, 0, this.lastRawDataChunk.length);
            int authTagLengthBits = 128;
            if (this.authTagProducer != null) {
                this.authTagProducer.update(finalBytes, 0, finalBytes.length);
                this.encodeAndWrite(finalBytes, 0, finalBytes.length, true);
            } else {
                this.encodeAndWrite(finalBytes, 0, finalBytes.length - 16, true);
            }
            this.out.write(new byte[]{46});
            if (this.authTagProducer == null) {
                this.encodeAndWrite(finalBytes, finalBytes.length - 16, 16, true);
            } else {
                byte[] authTag = this.authTagProducer.getTag();
                this.encodeAndWrite(authTag, 0, 16, true);
            }
        }
        catch (Exception ex) {
            LOG.warning("Content encryption failure");
            throw new JweException(JweException.Error.CONTENT_ENCRYPTION_FAILURE, (Throwable)ex);
        }
        this.flushed = true;
    }

    private byte[] newArray(byte[] src, int srcPos, int srcLen) {
        byte[] buf = new byte[srcLen];
        System.arraycopy(src, srcPos, buf, 0, srcLen);
        return buf;
    }

    private byte[] newArray(byte[] src, int srcPos, int srcLen, byte[] src2, int srcPos2, int srcLen2) {
        byte[] buf = new byte[srcLen + srcLen2];
        System.arraycopy(src, srcPos, buf, 0, srcLen);
        System.arraycopy(src2, srcPos2, buf, srcLen, srcLen2);
        return buf;
    }
}

