/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.OutboundSseEventBodyWriter;
import org.apache.cxf.jaxrs.sse.SseEventSinkImpl;
import org.apache.cxf.message.Message;

public class SseEventSinkContextProvider
implements ContextProvider<SseEventSink> {
    @Override
    public SseEventSink createContext(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get("HTTP.REQUEST");
        if (request == null) {
            throw new IllegalStateException("Unable to retrieve HTTP request from the context");
        }
        OutboundSseEventBodyWriter writer = new OutboundSseEventBodyWriter(ServerProviderFactory.getInstance(message), message.getExchange());
        AsyncResponseImpl async = new AsyncResponseImpl(message);
        Integer bufferSize = PropertyUtils.getInteger(message, "org.apache.cxf.sse.sink.buffer.size");
        SseEventSink sink = this.createSseEventSink(request, writer, async, bufferSize);
        message.put(SseEventSink.class, sink);
        return sink;
    }

    protected SseEventSink createSseEventSink(HttpServletRequest request, MessageBodyWriter<OutboundSseEvent> writer, AsyncResponse async, Integer bufferSize) {
        if (bufferSize != null) {
            return new SseEventSinkImpl(writer, async, request.getAsyncContext(), bufferSize);
        }
        return new SseEventSinkImpl(writer, async, request.getAsyncContext());
    }
}

