/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.sse.OutboundSseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

@Provider
public class OutboundSseEventBodyWriter
implements MessageBodyWriter<OutboundSseEvent> {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE = MediaType.valueOf((String)"text/event-stream");
    private static final byte[] COMMENT = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ID = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY = "retry: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEW_LINE = "\n".getBytes(StandardCharsets.UTF_8);
    private ServerProviderFactory factory;
    private Message message;

    protected OutboundSseEventBodyWriter() {
    }

    public OutboundSseEventBodyWriter(ServerProviderFactory factory, Exchange exchange) {
        this.factory = factory;
        this.message = new MessageImpl();
        this.message.setExchange(exchange);
    }

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return OutboundSseEvent.class.isAssignableFrom(cls) || SERVER_SENT_EVENTS_TYPE.isCompatible(mt);
    }

    public void writeTo(OutboundSseEvent p, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (p.getName() != null) {
            os.write(EVENT);
            os.write(p.getName().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getId() != null) {
            os.write(ID);
            os.write(p.getId().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getComment() != null) {
            os.write(COMMENT);
            os.write(p.getComment().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getReconnectDelay() > 0L) {
            os.write(RETRY);
            os.write(Long.toString(p.getReconnectDelay()).getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getData() != null) {
            Class<Object> payloadClass = p.getType();
            Object payloadType = p.getGenericType();
            if (payloadType == null) {
                payloadType = payloadClass;
            }
            if (payloadType == null && payloadClass == null) {
                payloadType = Object.class;
                payloadClass = Object.class;
            }
            os.write(DATA);
            this.writePayloadTo(payloadClass, (Type)payloadType, anns, p.getMediaType(), headers, p.getData(), os);
            os.write(NEW_LINE);
        }
        os.write(NEW_LINE);
    }

    private <T> void writePayloadTo(Class<T> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, Object data, OutputStream os) throws IOException, WebApplicationException {
        MessageBodyWriter<T> writer = null;
        if (this.message != null && this.factory != null) {
            writer = this.factory.createMessageBodyWriter(cls, type, anns, mt, this.message);
        }
        if (writer == null) {
            throw new InternalServerErrorException("No suitable message body writer for class: " + cls.getName());
        }
        writer.writeTo(data, cls, type, anns, mt, headers, os);
    }

    public long getSize(OutboundSseEvent t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

