/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

@Provider
public class JavaTimeTypesParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.equals(LocalDateTime.class)) {
            return new LocalDateTimeConverter();
        }
        if (rawType.equals(LocalDate.class)) {
            return new LocalDateConverter();
        }
        if (rawType.equals(LocalTime.class)) {
            return new LocalTimeConverter();
        }
        if (rawType.equals(OffsetDateTime.class)) {
            return new OffsetDateTimeConverter();
        }
        if (rawType.equals(OffsetTime.class)) {
            return new OffsetTimeConverter();
        }
        if (rawType.equals(ZonedDateTime.class)) {
            return new ZonedDateTimeConverter();
        }
        return null;
    }

    public class ZonedDateTimeConverter
    implements ParamConverter<ZonedDateTime> {
        public ZonedDateTime fromString(String value) {
            try {
                return ZonedDateTime.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(ZonedDateTime zonedDateTime) {
            return this.getFormatter().format(zonedDateTime);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_ZONED_DATE_TIME;
        }
    }

    public class OffsetTimeConverter
    implements ParamConverter<OffsetTime> {
        public OffsetTime fromString(String value) {
            try {
                return OffsetTime.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(OffsetTime offsetTime) {
            return this.getFormatter().format(offsetTime);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_OFFSET_TIME;
        }
    }

    public class OffsetDateTimeConverter
    implements ParamConverter<OffsetDateTime> {
        public OffsetDateTime fromString(String value) {
            try {
                return OffsetDateTime.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(OffsetDateTime offsetDateTime) {
            return this.getFormatter().format(offsetDateTime);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        }
    }

    public class LocalTimeConverter
    implements ParamConverter<LocalTime> {
        public LocalTime fromString(String value) {
            try {
                return LocalTime.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(LocalTime localTime) {
            return this.getFormatter().format(localTime);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_LOCAL_TIME;
        }
    }

    public class LocalDateConverter
    implements ParamConverter<LocalDate> {
        public LocalDate fromString(String value) {
            try {
                return LocalDate.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(LocalDate localDate) {
            return this.getFormatter().format(localDate);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_LOCAL_DATE;
        }
    }

    public class LocalDateTimeConverter
    implements ParamConverter<LocalDateTime> {
        public LocalDateTime fromString(String value) {
            try {
                return LocalDateTime.parse(value, this.getFormatter());
            }
            catch (DateTimeParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        }

        public String toString(LocalDateTime localDateTime) {
            return this.getFormatter().format(localDateTime);
        }

        protected DateTimeFormatter getFormatter() {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
    }
}

