/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;

public class CXFJAXRSFilter
implements Filter {
    private final CxfRsHttpListener delegate;
    private final String[] welcomeFiles;

    public CXFJAXRSFilter(CxfRsHttpListener delegate, String[] welcomeFiles) {
        this.delegate = delegate;
        this.welcomeFiles = new String[welcomeFiles.length];
        for (int i = 0; i < welcomeFiles.length; ++i) {
            this.welcomeFiles[i] = "/" + welcomeFiles[i];
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        HttpServletResponse httpServletResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
        if (!this.delegate.isCXFResource(httpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.defaultServletMatched(httpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (CxfRsHttpListener.TRY_STATIC_RESOURCES) {
            try (InputStream staticContent = this.delegate.findStaticContent(httpServletRequest, this.welcomeFiles);){
                if (staticContent != null) {
                    chain.doFilter(request, response);
                    return;
                }
            }
        }
        try {
            this.delegate.doInvoke((HttpRequest)new ServletRequestAdapter(httpServletRequest, httpServletResponse, request.getServletContext()), (HttpResponse)new ServletResponseAdapter(httpServletResponse));
        }
        catch (Exception e) {
            throw new ServletException("Error processing webservice request", (Throwable)e);
        }
    }

    private boolean defaultServletMatched(HttpServletRequest request) {
        ServletRegistration servletRegistration = request.getServletContext().getServletRegistration(request.getHttpServletMapping().getServletName());
        if ("default".equals(servletRegistration.getName())) {
            return true;
        }
        boolean welcomeFileRewriteDetected = false;
        for (String welcomeFile : this.welcomeFiles) {
            if (request.getRequestURI().endsWith(welcomeFile) || !request.getServletPath().endsWith(welcomeFile)) continue;
            welcomeFileRewriteDetected = true;
            break;
        }
        return welcomeFileRewriteDetected;
    }
}

