/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLConnection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.JreCompat;

class Jre9Compat
extends JreCompat {
    private static final Class<?> inaccessibleObjectExceptionClazz;
    private static final Method setApplicationProtocolsMethod;
    private static final Method getApplicationProtocolMethod;
    private static final Method setDefaultUseCaches;

    Jre9Compat() {
    }

    static boolean isSupported() {
        return inaccessibleObjectExceptionClazz != null;
    }

    @Override
    public boolean isInstanceOfInaccessibleObjectException(Throwable t) {
        if (t == null) {
            return false;
        }
        return inaccessibleObjectExceptionClazz.isAssignableFrom(t.getClass());
    }

    @Override
    public void setApplicationProtocols(SSLParameters sslParameters, String[] protocols) {
        try {
            setApplicationProtocolsMethod.invoke((Object)sslParameters, new Object[]{protocols});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String getApplicationProtocol(SSLEngine sslEngine) {
        try {
            return (String)getApplicationProtocolMethod.invoke((Object)sslEngine, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void disableCachingForJarUrlConnections() throws IOException {
        try {
            setDefaultUseCaches.invoke(null, "JAR", Boolean.FALSE);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Class<?> c1 = null;
        Method m2 = null;
        Method m3 = null;
        Method m4 = null;
        try {
            c1 = Class.forName("java.lang.reflect.InaccessibleObjectException");
            m2 = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            m3 = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
            m4 = URLConnection.class.getMethod("setDefaultUseCaches", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        inaccessibleObjectExceptionClazz = c1;
        setApplicationProtocolsMethod = m2;
        getApplicationProtocolMethod = m3;
        setDefaultUseCaches = m4;
    }
}

